/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types;

import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.interactions.InteractionInfo;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.utils.CoordinatesUtil;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.AngleProvider;
import gollorum.signpost.utils.BlockPartMetadata;
import gollorum.signpost.utils.NameProvider;
import gollorum.signpost.utils.math.geometry.AABB;
import gollorum.signpost.utils.math.geometry.Matrix4x4;
import gollorum.signpost.utils.math.geometry.TransformedBox;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LargeSignBlockPart
extends SignBlockPart<LargeSignBlockPart> {
    private static final AABB LOCAL_BOUNDS = new AABB(new Vector3(-9.0f, -14.0f, 2.0f), new Vector3(12.0f, -2.0f, 3.0f)).map(CoordinatesUtil::voxelToLocal);
    public static final BlockPartMetadata<LargeSignBlockPart> METADATA = new BlockPartMetadata<LargeSignBlockPart>("large_sign", (sign, compound) -> {
        compound.m_128365_("CoreData", (Tag)SignBlockPart.CoreData.SERIALIZER.write(sign.coreData));
        compound.m_128365_("Text0", (Tag)NameProvider.Serializer.write(sign.text[0]));
        compound.m_128365_("Text1", (Tag)NameProvider.Serializer.write(sign.text[1]));
        compound.m_128365_("Text2", (Tag)NameProvider.Serializer.write(sign.text[2]));
        compound.m_128365_("Text3", (Tag)NameProvider.Serializer.write(sign.text[3]));
    }, compound -> new LargeSignBlockPart(SignBlockPart.CoreData.SERIALIZER.read(compound.m_128469_("CoreData")), new NameProvider[]{NameProvider.fetchFrom(compound.m_128423_("Text0")), NameProvider.fetchFrom(compound.m_128423_("Text1")), NameProvider.fetchFrom(compound.m_128423_("Text2")), NameProvider.fetchFrom(compound.m_128423_("Text3"))}), LargeSignBlockPart.class);
    private NameProvider[] text;

    public LargeSignBlockPart(SignBlockPart.CoreData coreData, NameProvider[] text) {
        super(coreData);
        assert (text.length == 4);
        this.text = text;
    }

    public LargeSignBlockPart(AngleProvider angle, NameProvider[] text, boolean flip, ResourceLocation mainTexture, ResourceLocation secondaryTexture, Optional<Overlay> overlay, int color, Optional<WaystoneHandle> destination, ItemStack itemToDropOnBreak, PostBlock.ModelType modelType, boolean isLocked, boolean isMarkedForGeneration) {
        this(new SignBlockPart.CoreData(angle, flip, mainTexture, secondaryTexture, overlay, color, destination, modelType, itemToDropOnBreak, isLocked, isMarkedForGeneration), text);
    }

    public void setText(NameProvider[] text) {
        this.text = text;
    }

    public NameProvider[] getText() {
        return this.text;
    }

    @Override
    protected NameProvider[] getNameProviders() {
        return this.text;
    }

    @Override
    protected void regenerateTransformedBox() {
        this.transformedBounds = new TransformedBox(LOCAL_BOUNDS).rotateAlong(Matrix4x4.Axis.Y, this.coreData.angleProvider.get());
        if (this.coreData.flip) {
            this.transformedBounds = this.transformedBounds.scale(new Vector3(1.0f, 1.0f, -1.0f));
        }
    }

    private void notifyTextChanged(InteractionInfo info) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("Text0", (Tag)NameProvider.Serializer.write(this.text[0]));
        compound.m_128365_("Text1", (Tag)NameProvider.Serializer.write(this.text[1]));
        compound.m_128365_("Text2", (Tag)NameProvider.Serializer.write(this.text[2]));
        compound.m_128365_("Text3", (Tag)NameProvider.Serializer.write(this.text[3]));
        info.mutationDistributor.accept(compound);
    }

    @Override
    public void readMutationUpdate(CompoundTag compound, BlockEntity tile, Player editingPlayer) {
        if (editingPlayer != null && !editingPlayer.f_19853_.m_5776_() && tile instanceof WithOwner.OfSignpost && !this.hasThePermissionToEdit((WithOwner.OfSignpost)tile, editingPlayer)) {
            editingPlayer.m_213846_((Component)Component.m_237115_((String)"signpost.no_permission_to_edit_signpost"));
            return;
        }
        if (compound.m_128441_("Text0")) {
            this.text[0] = NameProvider.fetchFrom(compound.m_128423_("Text0"));
        }
        if (compound.m_128441_("Text1")) {
            this.text[1] = NameProvider.fetchFrom(compound.m_128423_("Text1"));
        }
        if (compound.m_128441_("Text2")) {
            this.text[2] = NameProvider.fetchFrom(compound.m_128423_("Text2"));
        }
        if (compound.m_128441_("Text3")) {
            this.text[3] = NameProvider.fetchFrom(compound.m_128423_("Text3"));
        }
        super.readMutationUpdate(compound, tile, editingPlayer);
    }

    @Override
    public LargeSignBlockPart copy() {
        return new LargeSignBlockPart(this.coreData.copy(), this.text);
    }

    @Override
    public BlockPartMetadata<LargeSignBlockPart> getMeta() {
        return METADATA;
    }

    @Override
    public void writeTo(CompoundTag compound) {
        METADATA.write(this, compound);
    }
}

