/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types;

import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.interactions.InteractionInfo;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.utils.CoordinatesUtil;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.AngleProvider;
import gollorum.signpost.utils.BlockPartMetadata;
import gollorum.signpost.utils.NameProvider;
import gollorum.signpost.utils.math.geometry.AABB;
import gollorum.signpost.utils.math.geometry.Matrix4x4;
import gollorum.signpost.utils.math.geometry.TransformedBox;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SmallWideSignBlockPart
extends SignBlockPart<SmallWideSignBlockPart> {
    private static final AABB LOCAL_BOUNDS = new AABB(new Vector3(-9.0f, -11.0f, 2.0f), new Vector3(16.0f, -5.0f, 3.0f)).map(CoordinatesUtil::voxelToLocal);
    public static final BlockPartMetadata<SmallWideSignBlockPart> METADATA = new BlockPartMetadata<SmallWideSignBlockPart>("small_wide_sign", (sign, compound) -> {
        compound.m_128365_("CoreData", (Tag)SignBlockPart.CoreData.SERIALIZER.write(sign.coreData));
        compound.m_128365_("Text", (Tag)NameProvider.Serializer.write(sign.text));
    }, compound -> new SmallWideSignBlockPart(SignBlockPart.CoreData.SERIALIZER.read(compound.m_128469_("CoreData")), NameProvider.fetchFrom(compound.m_128423_("Text"))), SmallWideSignBlockPart.class);
    private NameProvider text;

    public SmallWideSignBlockPart(SignBlockPart.CoreData coreData, NameProvider text) {
        super(coreData);
        this.text = text;
    }

    public SmallWideSignBlockPart(AngleProvider angle, NameProvider text, boolean flip, ResourceLocation mainTexture, ResourceLocation secondaryTexture, Optional<Overlay> overlay, int color, Optional<WaystoneHandle> destination, ItemStack itemToDropOnBreak, PostBlock.ModelType modelType, boolean isLocked, boolean isMarkedForGeneration) {
        this(new SignBlockPart.CoreData(angle, flip, mainTexture, secondaryTexture, overlay, color, destination, modelType, itemToDropOnBreak, isLocked, isMarkedForGeneration), text);
    }

    public void setText(NameProvider text) {
        this.text = text;
    }

    public NameProvider getText() {
        return this.text;
    }

    @Override
    protected NameProvider[] getNameProviders() {
        return new NameProvider[]{this.text};
    }

    @Override
    protected void regenerateTransformedBox() {
        this.transformedBounds = new TransformedBox(LOCAL_BOUNDS).rotateAlong(Matrix4x4.Axis.Y, this.coreData.angleProvider.get());
        if (this.coreData.flip) {
            this.transformedBounds = this.transformedBounds.scale(new Vector3(1.0f, 1.0f, -1.0f));
        }
    }

    private void notifyTextChanged(InteractionInfo info) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("Text", (Tag)NameProvider.Serializer.write(this.text));
        info.mutationDistributor.accept(compound);
    }

    @Override
    public void readMutationUpdate(CompoundTag compound, BlockEntity tile, Player editingPlayer) {
        if (editingPlayer != null && !editingPlayer.f_19853_.m_5776_() && tile instanceof WithOwner.OfSignpost && !this.hasThePermissionToEdit((WithOwner.OfSignpost)tile, editingPlayer)) {
            editingPlayer.m_213846_((Component)Component.m_237115_((String)"signpost.no_permission_to_edit_signpost"));
            return;
        }
        if (compound.m_128441_("Text")) {
            this.setText(NameProvider.fetchFrom(compound.m_128423_("Text")));
        }
        super.readMutationUpdate(compound, tile, editingPlayer);
    }

    @Override
    public SmallWideSignBlockPart copy() {
        return new SmallWideSignBlockPart(this.coreData.copy(), this.text);
    }

    @Override
    public BlockPartMetadata<SmallWideSignBlockPart> getMeta() {
        return METADATA;
    }

    @Override
    public void writeTo(CompoundTag compound) {
        METADATA.write(this, compound);
    }
}

