/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types.renderers;

import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.events.WaystoneUpdatedEvent;
import gollorum.signpost.utils.BlockPart;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;

public final class BlockPartWaystoneUpdateListener {
    private static final BlockPartWaystoneUpdateListener instance = new BlockPartWaystoneUpdateListener();
    private final WeakHashMap<BlockPart<?>, BiConsumer<BlockPart<?>, WaystoneUpdatedEvent>> listeners = new WeakHashMap();

    public static BlockPartWaystoneUpdateListener getInstance() {
        return instance;
    }

    public <T extends BlockPart<T>> void addListener(T part, BiConsumer<T, WaystoneUpdatedEvent> onUpdate) {
        this.listeners.put(part, (untypedPart, event) -> onUpdate.accept((Object)untypedPart, (WaystoneUpdatedEvent)event));
    }

    private BlockPartWaystoneUpdateListener() {
    }

    public void initialize() {
        this.listeners.clear();
        WaystoneLibrary.getInstance().updateEventDispatcher.addListener(event -> {
            for (Map.Entry entry : this.listeners.entrySet().stream().toList()) {
                ((BiConsumer)entry.getValue()).accept((BlockPart)entry.getKey(), event);
            }
        });
    }
}

