/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.blockpartdata.types.renderers.SignRenderer;
import gollorum.signpost.minecraft.rendering.ModelRegistry;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.modelGeneration.SignModel;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;

public class WideSignRenderer
extends SignRenderer<SmallWideSignBlockPart> {
    private static final float TEXT_OFFSET_RIGHT = 0.4375f;
    private static final float TEXT_OFFSET_LEFT = 0.6875f;
    private static final float MAXIMUM_TEXT_WIDTH = 1.125f;
    private static final float TEXT_RATIO = 1.3f;
    private static final float FONT_SIZE_VOXELS = 1.5384616f;

    @Override
    protected BakedModel makeBakedModel(SmallWideSignBlockPart sign) {
        return ModelRegistry.WideBakedSign.makeModel(sign);
    }

    @Override
    protected BakedModel makeBakedOverlayModel(SmallWideSignBlockPart sign, Overlay overlay) {
        return ModelRegistry.WideBakedSign.makeOverlayModel(sign, overlay);
    }

    @Override
    protected SignModel makeModel(SmallWideSignBlockPart sign) {
        return ModelRegistry.WideSign.makeModel(sign);
    }

    @Override
    protected SignModel makeOverlayModel(SmallWideSignBlockPart sign, Overlay overlay) {
        return ModelRegistry.WideSign.makeOverlayModel(sign, overlay);
    }

    @Override
    protected void renderText(SmallWideSignBlockPart sign, PoseStack matrix, Font fontRenderer, MultiBufferSource buffer, int combinedLights) {
        RenderingUtil.wrapInMatrixEntry(matrix, () -> {
            Optional overrideName;
            String text = sign.getText().get();
            if (sign.isMarkedForGeneration() && (overrideName = WaystoneLibrary.getInstance().getAllWaystoneNames(true).flatMap(s -> s.size() > 0 ? s.stream().skip(new Random().nextInt(s.size() - 1)).findFirst() : Optional.empty())).isPresent()) {
                text = (String)overrideName.get();
            }
            matrix.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            float scale = 0.012019231f;
            float MAX_WIDTH_FRAC = (float)fontRenderer.m_92895_(text) * scale / 1.125f;
            float offset = 0.4375f * Math.min(1.0f, MAX_WIDTH_FRAC);
            matrix.m_85837_(sign.isFlipped() ? (double)(offset - (float)fontRenderer.m_92895_(text) * (scale /= Math.max(1.0f, MAX_WIDTH_FRAC))) : (double)(-offset), (double)(-scale * 4.0f * 1.3f), -0.1878125);
            matrix.m_85841_(scale, scale * 1.3f, scale);
            fontRenderer.m_92811_(text, 0.0f, 0.0f, sign.getColor(), false, matrix.m_85850_().m_85861_(), buffer, false, 0, combinedLights);
        });
    }
}

