/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.compat;

import com.google.common.collect.Lists;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.compat.ExternalWaystone;
import gollorum.signpost.compat.ExternalWaystoneLibrary;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.networking.ReflectionEvent;
import gollorum.signpost.utils.EventDispatcher;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.StringSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public final class WaystonesAdapter
implements ExternalWaystoneLibrary.Adapter {
    private static WaystonesAdapter instance;
    private final EventDispatcher.Impl.WithPublicDispatch<Collection<ExternalWaystone>> onReply = new EventDispatcher.Impl.WithPublicDispatch();
    private static final String notActivatedKey = "gui.waystones.inventory.no_waystones_activated";

    private WaystonesAdapter() {
    }

    public static void register() {
        instance = new WaystonesAdapter();
        ExternalWaystoneLibrary.onInitialize().addListener(ex -> ex.registerAdapter(instance));
        PacketHandler.onInitialize().addListener(unit -> {
            PacketHandler.register(new RequestEvent(), -100);
            PacketHandler.register(new ReplyEvent(), -101);
        });
    }

    @Override
    public String typeTag() {
        return "waystones";
    }

    @Override
    public void requestKnownWaystones(Consumer<Collection<ExternalWaystone>> consumer) {
        this.onReply.addListener(consumer);
        PacketHandler.sendToServer(new RequestEvent());
    }

    @Override
    public Optional<ExternalWaystone> getData(WaystoneHandle handle) {
        return handle instanceof Handle ? this.getData((Handle)handle).map(w -> w) : Optional.empty();
    }

    private Optional<Waystone> getData(Handle handle) {
        return WaystoneManager.get((MinecraftServer)Signpost.getServerInstance()).getWaystoneById(handle.id).map(Waystone::new);
    }

    @Override
    public Optional<Component> cannotTeleportToBecause(Player player, WaystoneHandle handle) {
        if (!(handle instanceof Handle)) {
            return Optional.empty();
        }
        return this.getData((Handle)handle).map(waystone -> waystone.wrapped.isGlobal() || PlayerWaystoneManager.isWaystoneActivated((Player)player, (IWaystone)waystone.wrapped) ? Optional.empty() : Optional.of(Component.m_237115_((String)notActivatedKey))).orElse(Optional.empty());
    }

    @Override
    public WaystoneHandle read(FriendlyByteBuf buffer) {
        return new Handle(buffer.m_130259_());
    }

    @Override
    public WaystoneHandle read(CompoundTag compound) {
        return new Handle(compound.m_128342_("id"));
    }

    public static final class RequestEvent
    extends ReflectionEvent<RequestEvent> {
        @Override
        public Class<RequestEvent> getMessageClass() {
            return RequestEvent.class;
        }

        @Override
        public void handle(RequestEvent message, NetworkEvent.Context context) {
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)context).getSender()), new ReplyEvent.Packet(PlayerWaystoneManager.getWaystones((Player)context.getSender()).stream().map(Waystone::new).collect(Collectors.toList())));
        }
    }

    public static class Handle
    implements ExternalWaystone.Handle {
        public final UUID id;

        public Handle(UUID id) {
            this.id = id;
        }

        @Override
        public String modMark() {
            return "(Waystones)";
        }

        @Override
        public String noTeleportLangKey() {
            return "signpost.no_teleport_waystones_mod";
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            StringSerializer.instance.write(instance.typeTag(), buffer);
            buffer.m_130077_(this.id);
        }

        @Override
        public CompoundTag write(CompoundTag compound) {
            compound.m_128359_("type", instance.typeTag());
            compound.m_128362_("id", this.id);
            return compound;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Handle that = (Handle)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }

    public static class Waystone
    implements ExternalWaystone {
        public final IWaystone wrapped;

        public Waystone(IWaystone wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public String name() {
            return this.wrapped.getName();
        }

        @Override
        public WaystoneLocationData loc() {
            WorldLocation blockPos = new WorldLocation(this.wrapped.getPos(), this.wrapped.getDimension().m_135782_());
            return new WaystoneLocationData(blockPos, Vector3.fromBlockPos(blockPos.blockPos.m_121945_(this.spawnInDirection(blockPos))));
        }

        private Direction spawnInDirection(WorldLocation blockPos) {
            BlockState state;
            Level world = TileEntityUtils.toWorld(blockPos.world, false).orElse(null);
            BlockState blockState = state = world != null ? world.m_8055_(blockPos.blockPos) : null;
            if (state == null || !state.m_61138_((Property)WaystoneBlock.FACING)) {
                return Direction.NORTH;
            }
            Direction direction = (Direction)state.m_61143_((Property)WaystoneBlock.FACING);
            ArrayList directionCandidates = Lists.newArrayList((Object[])new Direction[]{direction, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH});
            for (Direction candidate : directionCandidates) {
                BlockPos offsetPos = blockPos.blockPos.m_121945_(candidate);
                BlockPos offsetPosUp = offsetPos.m_7494_();
                if (world.m_8055_(offsetPos).m_60828_((BlockGetter)world, offsetPos) || world.m_8055_(offsetPosUp).m_60828_((BlockGetter)world, offsetPosUp)) continue;
                return candidate;
            }
            return direction;
        }

        @Override
        public ExternalWaystone.Handle handle() {
            return new Handle(this.wrapped.getWaystoneUid());
        }
    }

    public static final class ReplyEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void encode(Packet message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.waystones.size());
            for (Waystone waystone : message.waystones) {
                net.blay09.mods.waystones.core.Waystone.write((FriendlyByteBuf)buffer, (IWaystone)waystone.wrapped);
            }
        }

        @Override
        public Packet decode(FriendlyByteBuf buffer) {
            int size = buffer.readInt();
            ArrayList<Waystone> waystones = new ArrayList<Waystone>();
            for (int i = 0; i < size; ++i) {
                waystones.add(new Waystone(net.blay09.mods.waystones.core.Waystone.read((FriendlyByteBuf)buffer)));
            }
            return new Packet(waystones);
        }

        @Override
        public void handle(Packet message, NetworkEvent.Context context) {
            WaystonesAdapter.instance.onReply.dispatch(new ArrayList<Waystone>(message.waystones), true);
        }

        public static final class Packet {
            public Collection<Waystone> waystones;

            public Packet(Collection<Waystone> waystones) {
                this.waystones = waystones;
            }
        }
    }
}

