/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import gollorum.signpost.BlockRestrictions;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.minecraft.config.Config;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class BlockRestrictions {
    public static final String commandName = "blockRestrictions";

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)commandName).then(BlockRestrictions.signposts())).then(BlockRestrictions.waystone());
    }

    private static ArgumentBuilder<CommandSourceStack, ?> signposts() {
        return ((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"signposts").then(BlockRestrictions.getter(BlockRestrictions.Type.Signpost))).then(BlockRestrictions.setter(BlockRestrictions.Type.Signpost));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> waystone() {
        return ((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"waystone").then(BlockRestrictions.getter(BlockRestrictions.Type.Waystone))).then(BlockRestrictions.setter(BlockRestrictions.Type.Waystone));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> getter(BlockRestrictions.Type type) {
        return ((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"get").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            return BlockRestrictions.get(type, (CommandSourceStack)context.getSource(), (Player)player);
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).requires(source -> source.m_6761_(3))).executes(context -> BlockRestrictions.get(type, (CommandSourceStack)context.getSource(), (Player)EntityArgument.m_91474_((CommandContext)context, (String)"player"))));
    }

    private static int get(BlockRestrictions.Type type, CommandSourceStack commandSource, Player targetedPlayer) {
        int left = gollorum.signpost.BlockRestrictions.getInstance().getRemaining(type, PlayerHandle.from((Entity)targetedPlayer));
        Optional<Component> subject = PlayerHandle.from(commandSource.m_81373_()).equals(PlayerHandle.from((Entity)targetedPlayer)) || targetedPlayer == null ? Optional.empty() : Optional.of(targetedPlayer.m_5446_());
        commandSource.m_81354_(left < 0 ? type.getUnlimitedRemainingTextComponent(subject) : type.getRemainingTextComponent(left, subject), false);
        return 1;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> setter(BlockRestrictions.Type type) {
        return ((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"set").requires(source -> source.m_6761_(((Integer)Config.Server.permissions.setBlockRestrictionPermissionLevel.get()).intValue()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)-1)).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            return BlockRestrictions.set(type, (CommandSourceStack)context.getSource(), player, IntegerArgumentType.getInteger((CommandContext)context, (String)"count"));
        })).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> BlockRestrictions.set(type, (CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count")))));
    }

    private static int set(BlockRestrictions.Type type, CommandSourceStack commandSource, ServerPlayer targetedPlayer, int count) {
        PlayerHandle tHandle = PlayerHandle.from((Entity)targetedPlayer);
        gollorum.signpost.BlockRestrictions.getInstance().setRemaining(type, tHandle, c -> count);
        Optional<Component> subject = PlayerHandle.from(commandSource.m_81373_()).equals(tHandle) || targetedPlayer == null ? Optional.empty() : Optional.of(targetedPlayer.m_5446_());
        commandSource.m_81354_(count < 0 ? type.getUnlimitedRemainingTextComponent(subject) : type.getRemainingTextComponent(count, subject), true);
        return 1;
    }
}

