/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import gollorum.signpost.minecraft.gui.utils.ConfigurableFont;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.Ticking;
import gollorum.signpost.minecraft.gui.utils.WithMutableX;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class InputBox
extends EditBox
implements WithMutableX,
Ticking {
    private boolean shouldDropShadow;
    private final ConfigurableFont configFont;
    private final List<Function<Integer, Boolean>> keyCodeConsumers = new ArrayList<Function<Integer, Boolean>>();
    private final double zOffset;

    public InputBox(Font configFont, Rect inputFieldRect, boolean shouldDropShadow, double zOffset) {
        this(new ConfigurableFont(configFont, !shouldDropShadow), inputFieldRect, shouldDropShadow, zOffset);
    }

    private InputBox(ConfigurableFont configFont, Rect inputFieldRect, boolean shouldDropShadow, double zOffset) {
        super((Font)configFont, inputFieldRect.point.x, inputFieldRect.point.y, inputFieldRect.width, inputFieldRect.height, (Component)Component.m_237113_((String)""));
        this.configFont = configFont;
        this.shouldDropShadow = shouldDropShadow;
        this.zOffset = zOffset;
    }

    @Override
    public void doTick() {
        super.m_94120_();
    }

    public boolean shouldDropShadow() {
        return this.shouldDropShadow;
    }

    public void setShouldDropShadow(boolean shouldDropShadow) {
        this.shouldDropShadow = shouldDropShadow;
        this.configFont.setShouldProhibitShadows(!shouldDropShadow);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        for (Function<Integer, Boolean> consumer : this.keyCodeConsumers) {
            if (!consumer.apply(keyCode).booleanValue()) continue;
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void addKeyCodeListener(int keyCode, Runnable action) {
        this.keyCodeConsumers.add(i -> {
            if (i == keyCode) {
                action.run();
                return true;
            }
            return false;
        });
    }

    public void m_6303_(PoseStack matrixStack, int p_94161_, int p_94162_, float p_94163_) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, this.zOffset);
        if (this.f_93622_ && !this.m_94219_()) {
            Objects.requireNonNull(this.configFont);
            int fromY = this.f_93621_ + (9 - this.f_93619_) / 2;
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)this.f_93620_, (int)fromY, (int)(this.f_93620_ + this.f_93618_), (int)(fromY + this.f_93619_), (int)0x40FFFFFF);
        }
        super.m_6303_(matrixStack, p_94161_, p_94162_, p_94163_);
        matrixStack.m_85849_();
    }

    public void m_94182_(boolean shouldBeBordered) {
        super.m_94182_(shouldBeBordered);
        this.f_93621_ = !shouldBeBordered ? (this.f_93621_ += (this.f_93619_ - 8) / 2) : (this.f_93621_ -= (this.f_93619_ - 8) / 2);
    }

    @Override
    public int getXPos() {
        return this.f_93620_;
    }

    @Override
    public int width() {
        return this.f_93618_;
    }

    @Override
    public void setXPos(int x) {
        this.f_93620_ = x;
    }
}

