/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.registry;

import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.items.Brush;
import gollorum.signpost.minecraft.items.GenerationWand;
import gollorum.signpost.minecraft.items.PostItem;
import gollorum.signpost.minecraft.items.WaystoneItem;
import gollorum.signpost.minecraft.items.Wrench;
import gollorum.signpost.minecraft.registry.BlockRegistry;
import java.util.List;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ItemRegistry {
    public static final CreativeModeTab ITEM_GROUP = new CreativeModeTab("signpost"){

        @NotNull
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)POSTS_ITEMS.get(0).get());
        }
    };
    private static final DeferredRegister<Item> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"signpost");
    private static final RegistryObject<Item> WAYSTONE_ITEM = REGISTER.register("waystone", () -> new WaystoneItem(WaystoneBlock.getInstance(), new Item.Properties().m_41491_(ITEM_GROUP)));
    private static final List<RegistryObject<Item>> ModelWaystoneItems = ModelWaystone.variants.stream().map(ItemRegistry::registerModelWaystoneItem).toList();
    private static final List<RegistryObject<Item>> POSTS_ITEMS = PostBlock.AllVariants.stream().map(ItemRegistry::registerPostItem).toList();
    private static final RegistryObject<Item> WaystoneGeneratorItem = REGISTER.register("waystone_generator", () -> new BlockItem((Block)BlockRegistry.WaystoneGenerator.get(), new Item.Properties()));
    public static final RegistryObject<Item> WRENCH = REGISTER.register("tool", () -> new Wrench(ITEM_GROUP));
    public static final RegistryObject<Item> BRUSH = REGISTER.register("brush", () -> new Brush(ITEM_GROUP));
    public static final RegistryObject<Item> GENERATION_WAND = REGISTER.register("generation_wand", GenerationWand::new);

    private static RegistryObject<Item> registerPostItem(PostBlock.Variant postVariant) {
        return REGISTER.register(postVariant.registryName, () -> new PostItem(postVariant.getBlock(), new Item.Properties().m_41491_(ITEM_GROUP)));
    }

    private static RegistryObject<Item> registerModelWaystoneItem(ModelWaystone.Variant variant) {
        return REGISTER.register(variant.registryName, () -> new WaystoneItem(variant.getBlock(), new Item.Properties().m_41491_(ITEM_GROUP)));
    }

    public static void register(IEventBus bus) {
        REGISTER.register(bus);
    }
}

