/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.storage.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.minecraft.block.tiles.WaystoneTile;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.registry.LootItemConditionRegistry;
import java.util.Arrays;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public final class PermissionCheck
implements LootItemCondition {
    private final Type type;

    public static LootItemConditionType createConditionType() {
        return new LootItemConditionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer());
    }

    public PermissionCheck(Type type) {
        this.type = type;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)LootItemConditionRegistry.permissionCheck.get();
    }

    public boolean test(LootContext lootContext) {
        if (!lootContext.m_78936_(LootContextParams.f_81455_)) {
            return true;
        }
        Entity thisEntity = (Entity)lootContext.m_165124_(LootContextParams.f_81455_);
        if (thisEntity.m_20310_(((Integer)Config.Server.permissions.pickUnownedWaystonePermissionLevel.get()).intValue())) {
            return true;
        }
        if (!lootContext.m_78936_(LootContextParams.f_81462_)) {
            return false;
        }
        BlockEntity blockEntity = (BlockEntity)lootContext.m_165124_(LootContextParams.f_81462_);
        if (!(blockEntity instanceof WaystoneTile)) {
            return false;
        }
        WaystoneTile waystoneTile = (WaystoneTile)blockEntity;
        return waystoneTile.getWaystoneOwner().map(owner -> owner.equals(PlayerHandle.from(thisEntity))).orElse(true);
    }

    private static final class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<PermissionCheck> {
        private Serializer() {
        }

        public void serialize(JsonObject jsonObject, PermissionCheck instance, JsonSerializationContext context) {
            jsonObject.addProperty("type", instance.type.name);
        }

        public PermissionCheck deserialize(JsonObject jsonObject, JsonDeserializationContext context) {
            String type = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"type");
            return new PermissionCheck(Arrays.stream(Type.values()).filter(t -> t.name.equals(type)).findFirst().get());
        }
    }

    public static enum Type {
        CanPickWaystone("pick_waystone");

        public final String name;

        private Type(String name) {
            this.name = name;
        }
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final Type type;

        public Builder(Type type) {
            this.type = type;
        }

        @NotNull
        public PermissionCheck build() {
            return new PermissionCheck(this.type);
        }
    }
}

