/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.worldgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.worldgen.VillageGenUtils;
import gollorum.signpost.minecraft.worldgen.VillageWaystone;
import gollorum.signpost.utils.AngleProvider;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.NameProvider;
import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.WaystoneData;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class VillageSignpost {
    private static final float smallSignRatio = 0.5f;
    private static Map<BlockPos, List<WaystoneHandle.Vanilla>> waystonesTargetedByVillage;

    public static void reset() {
        waystonesTargetedByVillage = new HashMap<BlockPos, List<WaystoneHandle.Vanilla>>();
    }

    public static boolean populate(PostTile tile, SignBlockPart<?> generatorPart, UUID generatorPartId, float height, ServerLevel level) {
        BlockPos pieceLocation = tile.m_58899_();
        BlockPos villageLocation = VillageGenUtils.getVillageLocationFor(level, pieceLocation, 512);
        Random random = new Random(level.m_7328_() ^ pieceLocation.m_121878_());
        Set<WaystoneHandle> blockedTargets = tile.getParts().stream().flatMap(p -> {
            Stream<Object> stream;
            BlockPart patt1993$temp = p.blockPart;
            if (patt1993$temp instanceof SignBlockPart) {
                SignBlockPart sbb = (SignBlockPart)patt1993$temp;
                stream = sbb.getDestination().stream();
            } else {
                stream = Stream.empty();
            }
            return stream;
        }).collect(Collectors.toSet());
        Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> possibleTargets = VillageSignpost.fetchPossibleTargets(pieceLocation, villageLocation, level.m_46472_().m_135782_(), random, blockedTargets);
        if (possibleTargets.isEmpty()) {
            return false;
        }
        Collection<WaystoneHandle.Vanilla> freshlyUsedWaystones = VillageSignpost.populateSignPostGeneration(tile, generatorPart, height, ((Direction)tile.m_58900_().m_61143_((Property)PostBlock.Facing)).m_122424_(), pieceLocation, level, random, possibleTargets);
        waystonesTargetedByVillage.computeIfAbsent(villageLocation, k -> new ArrayList()).addAll(freshlyUsedWaystones);
        tile.removePart(generatorPartId);
        tile.m_6596_();
        return true;
    }

    private static Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> fetchPossibleTargets(BlockPos pieceLocation, BlockPos villageLocation, ResourceLocation dimension, Random random, Set<WaystoneHandle> blockedTargets) {
        return VillageSignpost.allWaystoneTargets(villageLocation, dimension).map(e -> new Tuple<Tuple, Float>((Tuple)e, Float.valueOf((float)Math.sqrt(((BlockPos)e._1).m_123331_((Vec3i)pieceLocation)) * (0.5f + random.nextFloat())))).sorted((e1, e2) -> Float.compare(((Float)e1._2).floatValue(), ((Float)e2._2).floatValue())).map(Tuple::getLeft).filter(e -> WaystoneLibrary.getInstance().contains((WaystoneHandle.Vanilla)e._2)).filter(e -> !blockedTargets.contains(e._2)).collect(Collectors.toCollection(LinkedList::new));
    }

    private static Stream<Tuple<BlockPos, WaystoneHandle.Vanilla>> allWaystoneTargets(BlockPos villageLocation, ResourceLocation dimension) {
        Stream villageWaystones = VillageSignpost.villageWaystonesExceptSelf(villageLocation, dimension);
        return (Config.Server.worldGen.villagesOnlyTargetVillages() ? villageWaystones : Streams.concat((Stream[])new Stream[]{villageWaystones, VillageSignpost.nonVillageWaystones(dimension)})).filter(e -> !waystonesTargetedByVillage.containsKey(villageLocation) || !waystonesTargetedByVillage.get(villageLocation).contains(e._2));
    }

    private static Stream<Tuple<BlockPos, WaystoneHandle.Vanilla>> villageWaystonesExceptSelf(BlockPos villageLocation, ResourceLocation dimension) {
        return VillageWaystone.getAllEntries(dimension).stream().filter(e -> !((BlockPos)e.getKey()).equals((Object)villageLocation)).map(Tuple::from);
    }

    private static Stream<Tuple<BlockPos, WaystoneHandle.Vanilla>> nonVillageWaystones(ResourceLocation dimension) {
        return WaystoneLibrary.getInstance().getAllWaystoneInfo().stream().map(info -> new Tuple<BlockPos, WaystoneHandle.Vanilla>(info.locationData.block.blockPos, info.handle)).filter(t -> VillageWaystone.getAllEntries(dimension).stream().noneMatch(e -> ((WaystoneHandle.Vanilla)e.getValue()).equals(t._2)));
    }

    private static Collection<WaystoneHandle.Vanilla> populateSignPostGeneration(PostTile tile, SignBlockPart<?> generatorPart, float height, Direction facing, BlockPos pieceLocation, ServerLevel level, Random random, Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> possibleTargets) {
        return VillageSignpost.makeSign(tile, generatorPart, random, facing, level, pieceLocation, possibleTargets, height);
    }

    public static Collection<WaystoneHandle.Vanilla> makeSign(PostTile tile, SignBlockPart<?> generatorPart, Random random, Direction facing, ServerLevel world, BlockPos tilePos, Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> possibleTargets, float y) {
        if (possibleTargets.isEmpty()) {
            return Collections.emptySet();
        }
        return random.nextFloat() < 0.5f ? VillageSignpost.makeShortSigns(tile, generatorPart, facing, world, tilePos, possibleTargets, y) : VillageSignpost.makeWideSign(tile, generatorPart, facing, world, tilePos, possibleTargets, y);
    }

    private static Collection<WaystoneHandle.Vanilla> makeWideSign(PostTile tile, SignBlockPart<?> generatorPart, Direction facing, ServerLevel world, BlockPos tilePos, Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> possibleTargets, float y) {
        Optional<Tuple<Tuple<BlockPos, WaystoneHandle.Vanilla>, WaystoneData>> nextTargetOption = VillageSignpost.fetchNextTarget(possibleTargets);
        if (nextTargetOption.isEmpty()) {
            return Collections.emptySet();
        }
        Tuple target = (Tuple)nextTargetOption.get()._1;
        WaystoneData targetData = (WaystoneData)nextTargetOption.get()._2;
        Angle rotation = SignBlockPart.pointingAt(tilePos, (BlockPos)target._1);
        if (tile.getParts().stream().anyMatch(instance -> {
            SignBlockPart s;
            BlockPart patt6336$temp;
            return !(instance.blockPart instanceof PostBlockPart) && (!((patt6336$temp = instance.blockPart) instanceof SignBlockPart) || !(s = (SignBlockPart)patt6336$temp).isMarkedForGeneration()) && VillageSignpost.isNearly(instance.offset.y, y);
        })) {
            possibleTargets.add(target);
            return Collections.emptySet();
        }
        tile.addPart(new BlockPartInstance(new SmallWideSignBlockPart(new AngleProvider.WaystoneTarget(rotation), new NameProvider.WaystoneTarget(targetData.name), VillageSignpost.shouldFlip(facing, rotation), generatorPart.getMainTexture(), generatorPart.getSecondaryTexture(), VillageSignpost.overlayFor((WorldGenLevel)world, tilePos).or(generatorPart::getOverlay), generatorPart.getColor(), Optional.of((WaystoneHandle)target._2), ItemStack.f_41583_, tile.modelType, false, false), new Vector3(0.0f, y, 0.0f)), ItemStack.f_41583_, PlayerHandle.Invalid, false);
        return Collections.singleton((WaystoneHandle.Vanilla)target._2);
    }

    private static boolean isNearly(float a, float b) {
        return Math.abs(a - b) < 1.0E-5f;
    }

    private static Collection<WaystoneHandle.Vanilla> makeShortSigns(PostTile tile, SignBlockPart<?> generatorPart, Direction facing, ServerLevel world, BlockPos tilePos, Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> possibleTargets, float y) {
        Optional<Tuple<Tuple<BlockPos, WaystoneHandle.Vanilla>, WaystoneData>> nextTargetOption = VillageSignpost.fetchNextTarget(possibleTargets);
        if (nextTargetOption.isEmpty()) {
            return Collections.emptySet();
        }
        Tuple target = (Tuple)nextTargetOption.get()._1;
        WaystoneData targetData = (WaystoneData)nextTargetOption.get()._2;
        Angle rotation = SignBlockPart.pointingAt(tilePos, (BlockPos)target._1);
        boolean shouldFlip = VillageSignpost.shouldFlip(facing, rotation);
        Optional<Overlay> overlay = VillageSignpost.overlayFor((WorldGenLevel)world, tilePos).or(generatorPart::getOverlay);
        tile.addPart(new BlockPartInstance(new SmallShortSignBlockPart(new AngleProvider.WaystoneTarget(rotation), new NameProvider.WaystoneTarget(targetData.name), shouldFlip, generatorPart.getMainTexture(), generatorPart.getSecondaryTexture(), overlay, generatorPart.getColor(), Optional.of((WaystoneHandle)target._2), ItemStack.f_41583_, tile.modelType, false, false), new Vector3(0.0f, y, 0.0f)), ItemStack.f_41583_, PlayerHandle.Invalid, false);
        Optional<Tuple<Tuple<BlockPos, WaystoneHandle.Vanilla>, WaystoneData>> secondNextTargetOption = VillageSignpost.fetchNextTarget(possibleTargets);
        if (secondNextTargetOption.isEmpty()) {
            return Collections.singleton((WaystoneHandle.Vanilla)target._2);
        }
        Tuple secondTarget = (Tuple)secondNextTargetOption.get()._1;
        ArrayList<Tuple<BlockPos, WaystoneHandle.Vanilla>> skippedTargets = new ArrayList<Tuple<BlockPos, WaystoneHandle.Vanilla>>();
        while (secondTarget != null) {
            WaystoneData secondTargetData = (WaystoneData)secondNextTargetOption.get()._2;
            Angle secondRotation = SignBlockPart.pointingAt(tilePos, (BlockPos)secondTarget._1);
            boolean shouldSecondFlip = VillageSignpost.shouldFlip(facing, secondRotation);
            if (shouldSecondFlip == shouldFlip) {
                skippedTargets.add(secondTarget);
                secondNextTargetOption = VillageSignpost.fetchNextTarget(possibleTargets);
                secondTarget = secondNextTargetOption.isEmpty() ? null : (Tuple)secondNextTargetOption.get()._1;
                continue;
            }
            WaystoneHandle.Vanilla secondTargetHandle = (WaystoneHandle.Vanilla)secondTarget._2;
            tile.addPart(new BlockPartInstance(new SmallShortSignBlockPart(new AngleProvider.WaystoneTarget(secondRotation), new NameProvider.WaystoneTarget(secondTargetData.name), shouldSecondFlip, generatorPart.getMainTexture(), generatorPart.getSecondaryTexture(), overlay, generatorPart.getColor(), Optional.of(secondTargetHandle), ItemStack.f_41583_, tile.modelType, false, false), new Vector3(0.0f, y, 0.0f)), ItemStack.f_41583_, PlayerHandle.Invalid, false);
            break;
        }
        skippedTargets.addAll(possibleTargets);
        possibleTargets.clear();
        possibleTargets.addAll(skippedTargets);
        return secondTarget == null ? Collections.singleton((WaystoneHandle.Vanilla)target._2) : ImmutableList.of((Object)((WaystoneHandle.Vanilla)target._2), (Object)((WaystoneHandle.Vanilla)secondTarget._2));
    }

    private static Optional<Tuple<Tuple<BlockPos, WaystoneHandle.Vanilla>, WaystoneData>> fetchNextTarget(Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> possibleTargets) {
        Tuple<BlockPos, WaystoneHandle.Vanilla> target = null;
        WaystoneData targetData = null;
        while (target == null && possibleTargets.size() > 0) {
            target = possibleTargets.poll();
            if (target == null) continue;
            Optional<WaystoneData> dataOptional = WaystoneLibrary.getInstance().getData((WaystoneHandle.Vanilla)target._2);
            if (dataOptional.isPresent()) {
                targetData = dataOptional.get();
                continue;
            }
            target = null;
        }
        return target == null ? Optional.empty() : Optional.of(Tuple.of(target, targetData));
    }

    private static boolean shouldFlip(Direction facing, Angle signRotation) {
        float degrees = signRotation.add(Angle.fromDegrees(facing.m_122435_())).normalized().degrees();
        return degrees < -90.0f || degrees > 90.0f;
    }

    private static Optional<Overlay> overlayFor(WorldGenLevel world, BlockPos pos) {
        Holder biomeHolder = world.m_204166_(pos);
        Biome biome = (Biome)biomeHolder.m_203334_();
        boolean isJungle = biome.m_47536_().m_47818_().stream().flatMap(HolderSet::m_203614_).anyMatch(f -> ((PlacedFeature)f.get()).equals(VegetationPlacements.f_195444_.get()));
        if (biome.m_47519_((LevelReader)world, pos) || biome.m_47530_() == Biome.Precipitation.SNOW) {
            return Optional.of(Overlay.Snow);
        }
        if (isJungle) {
            return Optional.of(Overlay.Vine);
        }
        if (biome.m_47533_()) {
            return Optional.of(Overlay.Gras);
        }
        return Optional.empty();
    }
}

