/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import gollorum.signpost.utils.serialization.CompoundSerializable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public interface NameProvider {
    public static final CompoundSerializable<NameProvider> Serializer = new CompoundSerializable<NameProvider>(){

        @Override
        public CompoundTag write(NameProvider nameProvider, CompoundTag compound) {
            compound.m_128359_("name", nameProvider.get());
            compound.m_128359_("type", nameProvider instanceof Literal ? "literal" : "waystone");
            return compound;
        }

        @Override
        public boolean isContainedIn(CompoundTag compound) {
            return compound.m_128441_("name") && compound.m_128441_("type");
        }

        @Override
        public NameProvider read(CompoundTag compound) {
            String type = compound.m_128461_("type");
            String name = compound.m_128461_("name");
            return this.from(type, name);
        }

        @Override
        public void write(NameProvider nameProvider, FriendlyByteBuf buffer) {
            buffer.m_130070_(nameProvider instanceof Literal ? "literal" : "waystone");
            buffer.m_130070_(nameProvider.get());
        }

        @Override
        public NameProvider read(FriendlyByteBuf buffer) {
            return this.from(buffer.m_130277_(), buffer.m_130277_());
        }

        private NameProvider from(String type, String name) {
            switch (type) {
                case "literal": {
                    return new Literal(name);
                }
                case "waystone": {
                    return new WaystoneTarget(name);
                }
            }
            throw new RuntimeException("Invalid name provider type " + type);
        }

        @Override
        public Class<NameProvider> getTargetClass() {
            return NameProvider.class;
        }
    };

    public String get();

    public static NameProvider fetchFrom(Tag tag) {
        return tag instanceof CompoundTag && Serializer.isContainedIn((CompoundTag)tag) ? Serializer.read((CompoundTag)tag) : new Literal(tag.m_7916_());
    }

    public static final class Literal
    implements NameProvider {
        private final String name;

        @Override
        public String get() {
            return this.name;
        }

        public Literal(String name) {
            this.name = name;
        }
    }

    public static final class WaystoneTarget
    implements NameProvider {
        private String cachedName;

        public void setCachedName(String name) {
            this.cachedName = name;
        }

        @Override
        public String get() {
            return this.cachedName;
        }

        public WaystoneTarget(String cachedName) {
            this.cachedName = cachedName;
        }
    }
}

