/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneDataBase;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.compat.ExternalWaystone;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.gui.ConfirmTeleportGui;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.utils.Inventory;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.Delay;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.WaystoneHandleUtils;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.BufferSerializable;
import gollorum.signpost.utils.serialization.ComponentSerializer;
import gollorum.signpost.utils.serialization.StringSerializer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class Teleport {
    public static void toWaystone(WaystoneHandle waystone, ServerPlayer player) {
        if (waystone instanceof WaystoneHandle.Vanilla) {
            WaystoneLocationData waystoneData = WaystoneLibrary.getInstance().getLocationData((WaystoneHandle.Vanilla)waystone);
            Teleport.toWaystone(waystoneData, player);
        } else {
            Signpost.LOGGER.error("Tried to teleport to non-vanilla waystone " + ((ExternalWaystone.Handle)waystone).modMark());
        }
    }

    public static void toWaystone(WaystoneLocationData waystoneData, ServerPlayer player) {
        waystoneData.block.world.mapLeft(Optional::of).leftOr(i -> TileEntityUtils.findWorld(i, false)).ifPresent(unspecificWorld -> {
            if (!(unspecificWorld instanceof ServerLevel)) {
                return;
            }
            ServerLevel world = (ServerLevel)unspecificWorld;
            final Vector3 location = waystoneData.spawn;
            Vector3 diff = Vector3.fromBlockPos(waystoneData.block.blockPos).add(new Vector3(0.5f, 0.5f, 0.5f)).subtract(location.withY(y -> Float.valueOf(y.floatValue() + player.m_20192_())));
            final Angle yaw = Angle.between(0.0f, 1.0f, diff.x, diff.z);
            final Angle pitch = Angle.fromRadians((float)(1.5707963267948966 + Math.atan(Math.sqrt(diff.x * diff.x + diff.z * diff.z) / (double)diff.y)));
            Level oldWorld = player.f_19853_;
            BlockPos oldPos = player.m_20183_();
            if (!player.f_19853_.m_6042_().equals((Object)world.m_6042_()) && !((Boolean)Config.Server.teleport.enableAcrossDimensions.get()).booleanValue()) {
                player.m_213846_((Component)Component.m_237115_((String)"signpost.different_dimension"));
                return;
            }
            ITeleporter teleporter = new ITeleporter(){

                @Nullable
                public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
                    return new PortalInfo(location.asVec3(), Vec3.f_82478_, yaw.degrees(), pitch.degrees());
                }
            };
            if (((Boolean)Config.Server.teleport.allowVehicle.get()).booleanValue() && player.m_20159_()) {
                Entity vehicle = player.m_20202_();
                while (vehicle.m_20159_()) {
                    vehicle = vehicle.m_20202_();
                }
                if (!player.f_19853_.m_6042_().equals((Object)world.m_6042_())) {
                    Teleport.changeDimensionWithChildren(vehicle, world, teleporter);
                } else {
                    List<Mob> leashedMobs = Teleport.findLeashedMobs((Entity)player);
                    vehicle.m_146922_(yaw.degrees());
                    vehicle.m_146926_(pitch.degrees());
                    vehicle.m_6021_((double)location.x, (double)location.y, (double)location.z);
                    if (((Boolean)Config.Server.teleport.allowLead.get()).booleanValue()) {
                        Teleport.teleportLeadedAnimals((Entity)player, leashedMobs, world, teleporter);
                    } else {
                        Teleport.unleash(leashedMobs);
                    }
                }
            } else {
                List<Mob> leashedMobs = Teleport.findLeashedMobs((Entity)player);
                player.m_8999_(world, (double)location.x, (double)location.y, (double)location.z, yaw.degrees(), pitch.degrees());
                if (((Boolean)Config.Server.teleport.allowLead.get()).booleanValue()) {
                    Teleport.teleportLeadedAnimals((Entity)player, leashedMobs, world, teleporter);
                } else {
                    Teleport.unleash(leashedMobs);
                }
            }
            int steps = 6;
            TriConsumer playStepSound = (soundWorld, pos, volume) -> {
                SoundType soundType = Blocks.f_50069_.m_49966_().m_60827_();
                soundWorld.m_5594_(null, pos, soundType.m_56776_(), player.m_5720_(), soundType.m_56773_() * volume.floatValue(), soundType.m_56774_());
            };
            AtomicReference<Consumer<Integer>> playStepSounds = new AtomicReference<Consumer<Integer>>();
            playStepSounds.set(countdown -> {
                float volume = (float)countdown.intValue() / 6.0f;
                playStepSound.accept((Object)oldWorld, (Object)oldPos, (Object)Float.valueOf(volume));
                if (countdown > 1) {
                    Delay.onServerForFrames(15, () -> ((Consumer)playStepSounds.get()).accept(countdown - 1));
                }
            });
            ((Consumer)playStepSounds.get()).accept(6);
        });
    }

    private static <T extends Entity> T changeDimensionWithChildren(T entity, ServerLevel level, ITeleporter tp) {
        List<Entity> passengers = List.copyOf(entity.m_20197_());
        List<Mob> leashed = Teleport.findLeashedMobs(entity);
        Entity newCopy = entity.changeDimension(level, tp);
        if (newCopy == null) {
            return entity;
        }
        if (((Boolean)Config.Server.teleport.allowLead.get()).booleanValue()) {
            Teleport.teleportLeadedAnimals(newCopy, leashed, level, tp);
        } else {
            Teleport.unleash(leashed);
        }
        for (Entity p : passengers) {
            Entity p2 = Teleport.changeDimensionWithChildren(p, level, tp);
            Delay.onServerForFrames(5, () -> p2.m_7998_(newCopy, true));
        }
        return (T)newCopy;
    }

    private static List<Mob> findLeashedMobs(Entity player) {
        AABB searchBox = new AABB(player.m_20183_()).m_82400_(7.0);
        return player.f_19853_.m_6443_(Mob.class, searchBox, mob -> mob.m_21524_() == player);
    }

    private static void teleportLeadedAnimals(Entity player, List<Mob> leashed, ServerLevel level, ITeleporter tp) {
        for (Mob mob : leashed) {
            if (level != mob.f_19853_) {
                mob = Teleport.changeDimensionWithChildren(mob, level, tp);
            } else {
                PortalInfo portalIngo = tp.getPortalInfo((Entity)mob, level, null);
                mob.m_146922_(portalIngo.f_77678_);
                mob.m_146926_(portalIngo.f_77679_);
                mob.m_6021_(portalIngo.f_77676_.f_82479_, portalIngo.f_77676_.f_82480_, portalIngo.f_77676_.f_82481_);
            }
            Mob mob2 = mob;
            Delay.onServerForFrames(5, () -> mob2.m_21463_(player, true));
        }
    }

    private static void unleash(List<Mob> leashed) {
        for (Mob mob : leashed) {
            mob.m_21455_(true, true);
        }
    }

    public static void requestOnClient(Either<String, RequestGui.Package.Info> data, Optional<ConfirmTeleportGui.SignInfo> signInfo) {
        ConfirmTeleportGui.display(data, signInfo);
    }

    public static ItemStack getCost(Player player, Vector3 from, Vector3 to) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)Config.Server.teleport.costItem.get()));
        if (item == null || item.equals(Items.f_41852_) || player.m_7500_() || player.m_5833_()) {
            return ItemStack.f_41583_;
        }
        int distancePerPayment = (Integer)Config.Server.teleport.distancePerPayment.get();
        int distanceDependentCost = distancePerPayment < 0 ? 0 : (int)(from.distanceTo(to) / (float)distancePerPayment);
        return new ItemStack((ItemLike)item, (Integer)Config.Server.teleport.constantPayment.get() + distanceDependentCost);
    }

    public static final class RequestGui
    implements PacketHandler.Event<Package> {
        @Override
        public Class<Package> getMessageClass() {
            return Package.class;
        }

        @Override
        public void encode(Package message, FriendlyByteBuf buffer) {
            Either.BufferSerializer.of(StringSerializer.instance, Package.Info.serializer).write(message.data, buffer);
            PostTile.TilePartInfo.Serializer.optional().write(message.tilePartInfo, buffer);
        }

        @Override
        public Package decode(FriendlyByteBuf buffer) {
            return new Package((Either<String, Package.Info>)Either.BufferSerializer.of(StringSerializer.instance, Package.Info.serializer).read(buffer), (Optional<PostTile.TilePartInfo>)PostTile.TilePartInfo.Serializer.optional().read(buffer));
        }

        @Override
        public void handle(Package message, NetworkEvent.Context context) {
            if (((Boolean)Config.Client.enableConfirmationScreen.get()).booleanValue()) {
                Teleport.requestOnClient(message.data, message.tilePartInfo.flatMap(info -> TileEntityUtils.findTileEntity(info.dimensionKey, true, info.pos, PostTile.getBlockEntityType()).flatMap(tile -> tile.getPart(info.identifier).flatMap(part -> part.blockPart instanceof SignBlockPart ? Optional.of(new ConfirmTeleportGui.SignInfo((PostTile)tile, (SignBlockPart)part.blockPart, (PostTile.TilePartInfo)info, part.offset)) : Optional.empty()))));
            } else {
                message.data.consume(l -> Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)l), true), r -> PacketHandler.sendToServer(new Request.Package(r.waystoneName, r.handle)));
            }
        }

        public static final class Package {
            public final Either<String, Info> data;
            public final Optional<PostTile.TilePartInfo> tilePartInfo;

            public Package(Either<String, Info> data, Optional<PostTile.TilePartInfo> tilePartInfo) {
                this.data = data;
                this.tilePartInfo = tilePartInfo;
            }

            public static final class Info {
                public final int maxDistance;
                public final int distance;
                public final Optional<Component> cannotTeleportBecause;
                public final String waystoneName;
                public final ItemStack cost;
                public final Optional<WaystoneHandle> handle;
                public static final Serializer serializer = new Serializer();

                public Info(int maxDistance, int distance, Optional<Component> cannotTeleportBecause, String waystoneName, ItemStack cost, Optional<WaystoneHandle> handle) {
                    this.maxDistance = maxDistance;
                    this.distance = distance;
                    this.cannotTeleportBecause = cannotTeleportBecause;
                    this.waystoneName = waystoneName;
                    this.cost = cost;
                    this.handle = handle;
                }

                public static final class Serializer
                implements BufferSerializable<Info> {
                    @Override
                    public Class<Info> getTargetClass() {
                        return Info.class;
                    }

                    @Override
                    public void write(Info info, FriendlyByteBuf buffer) {
                        buffer.writeInt(info.maxDistance);
                        buffer.writeInt(info.distance);
                        ComponentSerializer.instance.optional().write(info.cannotTeleportBecause, buffer);
                        StringSerializer.instance.write(info.waystoneName, buffer);
                        buffer.m_130055_(info.cost);
                        buffer.m_236835_(info.handle, (b, h) -> h.write((FriendlyByteBuf)b));
                    }

                    @Override
                    public Info read(FriendlyByteBuf buffer) {
                        return new Info(buffer.readInt(), buffer.readInt(), (Optional<Component>)ComponentSerializer.instance.optional().read(buffer), StringSerializer.instance.read(buffer), buffer.m_130267_(), buffer.m_236860_(WaystoneHandle::read).flatMap(o -> o));
                    }
                }
            }
        }
    }

    public static final class Request
    implements PacketHandler.Event<Package> {
        @Override
        public Class<Package> getMessageClass() {
            return Package.class;
        }

        @Override
        public void encode(Package message, FriendlyByteBuf buffer) {
            StringSerializer.instance.write(message.waystoneName, buffer);
            buffer.writeBoolean(message.handle.isPresent());
            message.handle.ifPresent(h -> h.write(buffer));
        }

        @Override
        public Package decode(FriendlyByteBuf buffer) {
            return new Package(StringSerializer.instance.read(buffer), buffer.readBoolean() ? WaystoneHandle.read(buffer) : Optional.empty());
        }

        @Override
        public void handle(Package message, NetworkEvent.Context context) {
            ServerPlayer player = context.getSender();
            Optional<WaystoneHandle> waystone = message.handle.or(() -> WaystoneLibrary.getInstance().getHandleByName(message.waystoneName));
            Optional data = waystone.flatMap(WaystoneLibrary.getInstance()::getData);
            if (data.isPresent()) {
                WaystoneHandle handle = waystone.get();
                WaystoneLocationData waystoneData = ((WaystoneDataBase)data.get()).loc();
                Optional<Component> cannotTeleportBecause = WaystoneHandleUtils.cannotTeleportToBecause((Player)player, handle, message.waystoneName);
                int distance = (int)waystoneData.spawn.distanceTo(Vector3.fromVec3d(player.m_20182_()));
                int maxDistance = (Integer)Config.Server.teleport.maximumDistance.get();
                boolean isTooFarAway = maxDistance > 0 && distance > maxDistance;
                cannotTeleportBecause.ifPresent(arg_0 -> ((ServerPlayer)player).m_213846_(arg_0));
                if (isTooFarAway) {
                    player.m_213846_((Component)Component.m_237110_((String)"signpost.too_far_away", (Object[])new Object[]{Integer.toString(distance), Integer.toString(maxDistance)}));
                }
                if (cannotTeleportBecause.isPresent() || isTooFarAway) {
                    return;
                }
                Inventory.tryPay(player, Teleport.getCost((Player)player, Vector3.fromVec3d(player.m_20182_()), waystoneData.spawn), p -> Teleport.toWaystone(waystoneData, p));
            } else {
                player.m_213846_((Component)Component.m_237110_((String)"signpost.waystone_not_found", (Object[])new Object[]{Colors.wrap(message.waystoneName, Colors.highlight)}));
            }
        }

        public static final class Package {
            public final String waystoneName;
            public final Optional<WaystoneHandle> handle;

            public Package(String waystoneName, Optional<WaystoneHandle> handle) {
                this.waystoneName = waystoneName;
                this.handle = handle;
            }
        }
    }
}

