/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types;

import gollorum.signpost.Signpost;
import gollorum.signpost.Teleport;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.renderers.BlockPartWaystoneUpdateListener;
import gollorum.signpost.events.WaystoneUpdatedEvent;
import gollorum.signpost.interactions.Interactable;
import gollorum.signpost.interactions.InteractionInfo;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.gui.PaintSignGui;
import gollorum.signpost.minecraft.gui.RequestSignGui;
import gollorum.signpost.minecraft.items.Brush;
import gollorum.signpost.minecraft.items.GenerationWand;
import gollorum.signpost.minecraft.utils.Texture;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.AngleProvider;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.NameProvider;
import gollorum.signpost.utils.WaystoneHandleUtils;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Intersectable;
import gollorum.signpost.utils.math.geometry.Ray;
import gollorum.signpost.utils.math.geometry.TransformedBox;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.ItemStackSerializer;
import gollorum.signpost.utils.serialization.OptionalBufferSerializer;
import gollorum.signpost.utils.serialization.OptionalSerializer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.PacketDistributor;

public abstract class SignBlockPart<Self extends SignBlockPart<Self>>
implements BlockPart<Self> {
    protected CoreData coreData;
    protected TransformedBox transformedBounds;

    public static Angle pointingAt(BlockPos block, BlockPos target) {
        BlockPos diff = target.m_121996_((Vec3i)block);
        return Angle.between(diff.m_123341_(), diff.m_123343_(), 1.0f, 0.0f);
    }

    public Optional<WaystoneHandle> getDestination() {
        return this.coreData.destination;
    }

    protected SignBlockPart(CoreData coreData) {
        this.coreData = coreData;
        this.setAngle(coreData.angleProvider);
        this.setTextures(coreData.mainTexture, coreData.secondaryTexture);
        this.setOverlay(coreData.overlay);
        this.setFlip(coreData.flip);
    }

    public void setAngle(AngleProvider angleProvider) {
        this.coreData.angleProvider = angleProvider;
        this.regenerateTransformedBox();
    }

    protected abstract NameProvider[] getNameProviders();

    @Override
    public void attachTo(PostTile tile) {
        BlockPos myBlockPos = tile.m_58899_();
        BlockPartWaystoneUpdateListener.getInstance().addListener(this, (self, event) -> SignBlockPart.onWaystoneUpdated(myBlockPos, self, event));
    }

    private static void onWaystoneUpdated(BlockPos myBlockPos, SignBlockPart<?> self, WaystoneUpdatedEvent event) {
        self.getDestination().ifPresent(handle -> {
            if (handle.equals(event.handle)) {
                if (self.getAngle() instanceof AngleProvider.WaystoneTarget) {
                    ((AngleProvider.WaystoneTarget)self.getAngle()).setCachedAngle(SignBlockPart.pointingAt(myBlockPos, event.location.block.blockPos));
                }
                for (NameProvider np : self.getNameProviders()) {
                    if (!(np instanceof NameProvider.WaystoneTarget)) continue;
                    ((NameProvider.WaystoneTarget)np).setCachedName(event.name);
                }
            }
        });
    }

    public void setFlip(boolean flip) {
        this.coreData.flip = flip;
        this.setTextures(this.coreData.mainTexture, this.coreData.secondaryTexture);
        this.setOverlay(this.coreData.overlay);
        this.regenerateTransformedBox();
    }

    public void setColor(int color) {
        this.coreData.color = color;
    }

    public void setDestination(Optional<WaystoneHandle> destination) {
        this.coreData.destination = destination;
    }

    public void setItemToDropOnBreak(ItemStack itemToDropOnBreak) {
        this.coreData.itemToDropOnBreak = itemToDropOnBreak;
    }

    private void setModelType(PostBlock.ModelType modelType) {
        this.coreData.modelType = modelType;
    }

    public ItemStack getItemToDropOnBreak() {
        return this.coreData.itemToDropOnBreak;
    }

    public boolean isFlipped() {
        return this.coreData.flip;
    }

    public int getColor() {
        return this.coreData.color;
    }

    public PostBlock.ModelType getModelType() {
        return this.coreData.modelType;
    }

    public boolean isLocked() {
        return this.coreData.isLocked;
    }

    public boolean isMarkedForGeneration() {
        return this.coreData.isMarkedForGeneration;
    }

    @Override
    public boolean hasThePermissionToEdit(WithOwner tile, @Nullable Player player) {
        return !(tile instanceof WithOwner.OfSignpost) || !this.coreData.isLocked || player == null || ((WithOwner.OfSignpost)tile).getSignpostOwner().map(o -> o.id.equals(player.m_20148_())).orElse(true) != false || player.m_20310_(((Integer)Config.Server.permissions.editLockedSignCommandPermissionLevel.get()).intValue());
    }

    private void setTextures(Texture texture, Texture textureDark) {
        this.coreData.mainTexture = texture;
        this.coreData.secondaryTexture = textureDark;
    }

    public Texture getMainTexture() {
        return this.coreData.mainTexture;
    }

    public Texture getSecondaryTexture() {
        return this.coreData.secondaryTexture;
    }

    public void setMainTexture(Texture tex) {
        this.coreData.mainTexture = tex;
    }

    public void setSecondaryTexture(Texture tex) {
        this.coreData.secondaryTexture = tex;
    }

    private void setOverlay(Optional<Overlay> overlay) {
        this.coreData.overlay = overlay;
    }

    public Optional<Overlay> getOverlay() {
        return this.coreData.overlay;
    }

    protected abstract void regenerateTransformedBox();

    @Override
    public Intersectable<Ray, Float> getIntersection() {
        return this.isMarkedForGeneration() && !Config.Server.worldGen.debugMode() ? new Intersectable.Not() : this.transformedBounds;
    }

    @Override
    public Interactable.InteractionResult interact(InteractionInfo info) {
        ItemStack heldItem = info.player.m_21120_(info.hand);
        if (!info.isRemote) {
            if (this.holdsAngleTool(info)) {
                if (info.player.m_6047_()) {
                    this.setFlip(!this.isFlipped());
                    this.notifyFlipChanged(info);
                } else {
                    Vector3 diff = info.traceResult.ray.start.negated().add(0.5f, 0.5f, 0.5f).withY(0.0f).normalized();
                    Vector3 rayDir = info.traceResult.ray.dir.withY(0.0f).normalized();
                    Angle angleToPost = Angle.between(rayDir.x, rayDir.z, diff.x, diff.z).normalized();
                    this.setAngle(new AngleProvider.Literal(this.coreData.angleProvider.get().add(Angle.fromDegrees(angleToPost.radians() < 0.0f ? 15.0f : -15.0f))));
                    this.notifyAngleChanged(info);
                }
            } else if (SignBlockPart.isGenerationWand(heldItem)) {
                this.coreData.isMarkedForGeneration = !this.coreData.isMarkedForGeneration;
                this.notifyMarkedForGenerationChanged(info);
            } else if (!SignBlockPart.isBrush(heldItem)) {
                this.tryTeleport((ServerPlayer)info.player, info.getTilePartInfo());
            }
        } else if (SignBlockPart.isBrush(heldItem)) {
            this.paint(info);
        }
        return Interactable.InteractionResult.Accepted;
    }

    private void tryTeleport(ServerPlayer player, PostTile.TilePartInfo tilePartInfo) {
        if (((Boolean)Config.Server.teleport.enableTeleport.get()).booleanValue() && this.coreData.destination.isPresent() && (!(this.coreData.destination.get() instanceof WaystoneHandle.Vanilla) || WaystoneLibrary.getInstance().contains((WaystoneHandle.Vanilla)this.coreData.destination.get()))) {
            WaystoneHandle dest = this.coreData.destination.get();
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new Teleport.RequestGui.Package(Either.rightIfPresent(WaystoneLibrary.getInstance().getData(dest), () -> "signpost.waystone_not_found").mapRight(data -> {
                Optional<Component> cannotTeleportBecause = WaystoneHandleUtils.cannotTeleportToBecause((Player)player, dest, data.name());
                int distance = (int)data.loc().spawn.distanceTo(Vector3.fromVec3d(player.m_20182_()));
                return new Teleport.RequestGui.Package.Info((Integer)Config.Server.teleport.maximumDistance.get(), distance, cannotTeleportBecause, data.name(), Teleport.getCost((Player)player, Vector3.fromVec3d(player.m_20182_()), data.loc().spawn), Optional.of(data.handle()));
            }), Optional.of(tilePartInfo)));
        } else {
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new RequestSignGui.Package(tilePartInfo));
        }
    }

    private boolean holdsAngleTool(InteractionInfo info) {
        ItemStack itemStack = info.player.m_21120_(info.hand);
        return !itemStack.m_41619_() && PostTile.isAngleTool(itemStack.m_41720_());
    }

    private static boolean isBrush(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41613_() < 1) {
            return false;
        }
        Item item = itemStack.m_41720_();
        return item instanceof Brush;
    }

    private static boolean isGenerationWand(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41613_() < 1) {
            return false;
        }
        Item item = itemStack.m_41720_();
        return item instanceof GenerationWand;
    }

    private Interactable.InteractionResult paint(InteractionInfo info) {
        if (info.isRemote) {
            PaintSignGui.display(info.tile, this, info.traceResult.id);
        }
        return Interactable.InteractionResult.Accepted;
    }

    protected void notifyAngleChanged(InteractionInfo info) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("Angle", (Tag)AngleProvider.Serializer.write(this.coreData.angleProvider));
        info.mutationDistributor.accept(compound);
    }

    protected void notifyTextureChanged(InteractionInfo info) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("Texture", (Tag)Texture.Serializer.write(this.coreData.mainTexture));
        compound.m_128365_("TextureDark", (Tag)Texture.Serializer.write(this.coreData.secondaryTexture));
        info.mutationDistributor.accept(compound);
    }

    protected void notifyFlipChanged(InteractionInfo info) {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("Flip", this.coreData.flip);
        info.mutationDistributor.accept(compound);
    }

    protected void notifyMarkedForGenerationChanged(InteractionInfo info) {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("IsMarkedForGeneration", this.coreData.isMarkedForGeneration);
        info.mutationDistributor.accept(compound);
    }

    @Override
    public void readMutationUpdate(CompoundTag compound, BlockEntity tile, Player editingPlayer) {
        if (compound.m_128441_("CoreData")) {
            compound = compound.m_128469_("CoreData");
        }
        if (compound.m_128441_("Angle")) {
            this.setAngle(AngleProvider.fetchFrom(compound.m_128469_("Angle")));
        }
        boolean updateTextures = false;
        if (compound.m_128441_("Texture")) {
            this.coreData.mainTexture = Texture.readFrom(compound.m_128423_("Texture"));
            updateTextures = true;
        }
        if (compound.m_128441_("TextureDark")) {
            this.coreData.secondaryTexture = Texture.readFrom(compound.m_128423_("TextureDark"));
            updateTextures = true;
        }
        if (updateTextures) {
            this.setTextures(this.coreData.mainTexture, this.coreData.secondaryTexture);
        }
        if (compound.m_128441_("Flip")) {
            this.setFlip(compound.m_128471_("Flip"));
        }
        if (compound.m_128441_("Color")) {
            this.setColor(compound.m_128451_("Color"));
        }
        if (compound.m_128441_("Destination")) {
            CompoundTag dest = compound.m_128469_("Destination");
            if (dest.m_128471_("IsPresent")) {
                Optional<WaystoneHandle> d2 = WaystoneHandle.read(dest);
                if (d2.isPresent()) {
                    this.setDestination(d2);
                } else {
                    Signpost.LOGGER.error("Error deserializing waystone handle of unknown type: " + dest.m_128461_("type"));
                }
            } else {
                this.setDestination(Optional.empty());
            }
        }
        if (compound.m_128441_("ItemToDropOnBreak")) {
            this.setItemToDropOnBreak(ItemStackSerializer.Instance.read(compound.m_128469_("ItemToDropOnBreak")));
        }
        if (compound.m_128441_("ModelType")) {
            PostBlock.ModelType.getByName(compound.m_128461_("ModelType"), true).ifPresent(this::setModelType);
        }
        OptionalBufferSerializer overlaySerializer = Overlay.Serializer.optional();
        if (compound.m_128441_("Overlay")) {
            this.setOverlay((Optional<Overlay>)((OptionalSerializer)overlaySerializer).read(compound.m_128469_("Overlay")));
        }
        if (compound.m_128441_("IsLocked") && (editingPlayer == null || editingPlayer.f_19853_.m_5776_() || ((WithOwner.OfSignpost)tile).getSignpostOwner().map(owner -> editingPlayer.m_20148_().equals(owner.id)).orElse(true).booleanValue() || editingPlayer.m_20310_(((Integer)Config.Server.permissions.editLockedSignCommandPermissionLevel.get()).intValue()))) {
            this.coreData.isLocked = compound.m_128471_("IsLocked");
        }
        if (compound.m_128441_("IsMarkedForGeneration")) {
            this.coreData.isMarkedForGeneration = compound.m_128471_("IsMarkedForGeneration");
        }
        tile.m_6596_();
    }

    @Override
    public Collection<ItemStack> getDrops(PostTile tile) {
        return Collections.singleton(this.coreData.itemToDropOnBreak);
    }

    private void dropOn(Level world, BlockPos pos) {
        if (!this.coreData.itemToDropOnBreak.m_41619_() && !world.m_5776_()) {
            ItemEntity itementity = new ItemEntity(world, (double)pos.m_123341_() + (double)world.m_213780_().m_188501_() * 0.5 + 0.25, (double)pos.m_123342_() + (double)world.m_213780_().m_188501_() * 0.5 + 0.25, (double)pos.m_123343_() + (double)world.m_213780_().m_188501_() * 0.5 + 0.25, this.coreData.itemToDropOnBreak);
            itementity.m_32060_();
            world.m_7967_((Entity)itementity);
        }
    }

    public AngleProvider getAngle() {
        return this.coreData.angleProvider;
    }

    public abstract Self copy();

    @Override
    public Collection<Texture> getAllTextures() {
        return Arrays.asList(this.getMainTexture(), this.getSecondaryTexture());
    }

    protected static final class CoreData {
        public AngleProvider angleProvider;
        public boolean flip;
        public Texture mainTexture;
        public Texture secondaryTexture;
        public Optional<Overlay> overlay;
        public int color;
        public Optional<WaystoneHandle> destination;
        public PostBlock.ModelType modelType;
        public ItemStack itemToDropOnBreak;
        public boolean isLocked;
        public boolean isMarkedForGeneration;
        public static final Serializer SERIALIZER = new Serializer();

        public CoreData(AngleProvider angleProvider, boolean flip, Texture mainTexture, Texture secondaryTexture, Optional<Overlay> overlay, int color, Optional<WaystoneHandle> destination, PostBlock.ModelType modelType, ItemStack itemToDropOnBreak, boolean isLocked, boolean isMarkedForGeneration) {
            this.angleProvider = angleProvider;
            this.flip = flip;
            this.mainTexture = mainTexture;
            this.secondaryTexture = secondaryTexture;
            this.overlay = overlay;
            this.color = color;
            this.destination = destination;
            this.modelType = modelType;
            this.itemToDropOnBreak = itemToDropOnBreak;
            this.isLocked = isLocked;
            this.isMarkedForGeneration = isMarkedForGeneration;
        }

        public CoreData copy() {
            return new CoreData(this.angleProvider, this.flip, this.mainTexture, this.secondaryTexture, this.overlay, this.color, this.destination, this.modelType, this.itemToDropOnBreak, this.isLocked, this.isMarkedForGeneration);
        }

        public static final class Serializer
        implements CompoundSerializable<CoreData> {
            private Serializer() {
            }

            @Override
            public CompoundTag write(CoreData coreData, CompoundTag compound) {
                compound.m_128365_("Angle", (Tag)AngleProvider.Serializer.write(coreData.angleProvider));
                compound.m_128379_("Flip", coreData.flip);
                compound.m_128365_("Texture", (Tag)Texture.Serializer.write(coreData.mainTexture));
                compound.m_128365_("TextureDark", (Tag)Texture.Serializer.write(coreData.secondaryTexture));
                compound.m_128365_("Overlay", (Tag)Overlay.Serializer.optional().write(coreData.overlay));
                compound.m_128405_("Color", coreData.color);
                CompoundTag dest = new CompoundTag();
                dest.m_128379_("IsPresent", coreData.destination.isPresent());
                coreData.destination.ifPresent(d -> d.write(dest));
                compound.m_128365_("Destination", (Tag)dest);
                compound.m_128365_("ItemToDropOnBreak", (Tag)ItemStackSerializer.Instance.write(coreData.itemToDropOnBreak));
                compound.m_128359_("ModelType", coreData.modelType.name);
                compound.m_128379_("IsLocked", coreData.isLocked);
                compound.m_128379_("IsMarkedForGeneration", coreData.isMarkedForGeneration);
                return compound;
            }

            @Override
            public boolean isContainedIn(CompoundTag compound) {
                return compound.m_128441_("Angle") && compound.m_128441_("Flip") && compound.m_128441_("Texture") && compound.m_128441_("TextureDark") && compound.m_128441_("Overlay") && compound.m_128441_("Color") && compound.m_128441_("Destination") && compound.m_128441_("ItemToDropOnBreak") && compound.m_128441_("IsLocked") && compound.m_128441_("IsMarkedForGeneration");
            }

            @Override
            public CoreData read(CompoundTag compound) {
                Optional<WaystoneHandle> destination;
                CompoundTag dest = compound.m_128469_("Destination");
                if (dest.m_128471_("IsPresent")) {
                    Optional<WaystoneHandle> d2 = WaystoneHandle.read(dest);
                    if (!d2.isPresent()) {
                        Signpost.LOGGER.error("Error deserializing waystone handle of unknown type: " + dest.m_128461_("type"));
                    }
                    destination = d2;
                } else {
                    destination = Optional.empty();
                }
                return new CoreData(AngleProvider.fetchFrom(compound.m_128469_("Angle")), compound.m_128471_("Flip"), Texture.readFrom(compound.m_128423_("Texture")), Texture.readFrom(compound.m_128423_("TextureDark")), (Optional<Overlay>)((OptionalSerializer)Overlay.Serializer.optional()).read(compound.m_128469_("Overlay")), compound.m_128451_("Color"), destination, PostBlock.ModelType.getByName(compound.m_128461_("ModelType"), true).orElseThrow(() -> new RuntimeException("Tried to load sign post model type " + compound.m_128461_("ModelType") + ", but it hasn't been registered. @Dev: You have to call Post.ModelType.register")), ItemStackSerializer.Instance.read(compound.m_128469_("ItemToDropOnBreak")), compound.m_128471_("IsLocked"), compound.m_128471_("IsMarkedForGeneration"));
            }

            @Override
            public Class<CoreData> getTargetClass() {
                return CoreData.class;
            }
        }
    }
}

