/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block;

import gollorum.signpost.BlockRestrictions;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.block.tiles.WaystoneTile;
import gollorum.signpost.security.WithCountRestriction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModelWaystone
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
WithCountRestriction {
    public static final BooleanProperty Waterlogged = BlockStateProperties.f_61362_;
    public static final DirectionProperty Facing = BlockStateProperties.f_61374_;
    private static final String REGISTRY_NAME = "waystone_model";
    public static final List<Variant> variants = new ArrayList<Variant>();
    public static Variant simple_0 = new Variant("simple_0", "0", Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75), 1.0f);
    public static Variant simple_1 = new Variant("simple_1", "0", Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75), 1.0f);
    public static Variant simple_2 = new Variant("simple_2", "0", Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.75, (double)0.6875), 0.0f);
    public static Variant detailed_0 = new Variant("detailed_0", "1", Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75), 2.0f);
    public static Variant detailed_1 = new Variant("detailed_1", "1", Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.75, (double)0.75), 0.0f);
    public static Variant aer = new Variant("aer", "2", Shapes.m_83048_((double)0.05f, (double)0.0, (double)0.05f, (double)0.95f, (double)0.6f, (double)0.95f), 0.0f);
    public static Variant dwarf = new Variant("dwarf", "2", Shapes.m_83048_((double)0.05f, (double)0.0, (double)0.05f, (double)0.95f, (double)0.4375, (double)0.95f), 2.0f);
    public static Variant ygnar = new Variant("ygnar", "2", Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)0.875), 0.0f);
    public static final Variant generationMarker = simple_0;
    public final Variant variant;

    private ModelWaystone(Variant variant) {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76283_, (MaterialColor)MaterialColor.f_76409_).m_60913_(1.5f, 6.0f).m_60955_().m_60971_((x, y, z) -> false).m_60999_());
        this.variant = variant;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)Waterlogged, (Comparable)Boolean.valueOf(false))).m_61124_((Property)Facing, (Comparable)Direction.NORTH));
    }

    public String m_7705_() {
        return WaystoneBlock.getInstance().m_7705_() + "_" + this.variant.langPrefix + "_" + this.variant.name;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        WaystoneBlock.onRightClick(world, pos, player);
        return InteractionResult.CONSUME;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{Waterlogged}).m_61104_(new Property[]{Facing});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)Facing, (Comparable)context.m_8125_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        if (!state.m_61138_((Property)Facing)) {
            return state;
        }
        return (BlockState)state.m_61124_((Property)Facing, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)Facing)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        if (!state.m_61138_((Property)Facing)) {
            return state;
        }
        return (BlockState)state.m_61124_((Property)Facing, (Comparable)((Direction)state.m_61143_((Property)Facing)).m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WaystoneTile(pos, state);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        WaystoneBlock.registerOwnerAndRequestGui(world, pos, placer, stack);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)Waterlogged) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)Waterlogged) == false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.variant.shape;
    }

    @Override
    public BlockRestrictions.Type getBlockRestrictionType() {
        return BlockRestrictions.Type.Waystone;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6786_(LevelAccessor world, BlockPos pos, BlockState state) {
        super.m_6786_(world, pos, state);
        if (!world.m_5776_() && world instanceof Level) {
            WaystoneTile.onRemoved((ServerLevel)world, pos);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return WaystoneBlock.fillClonedItemStack(super.getCloneItemStack(state, target, level, pos, player), level, pos, player);
    }

    static {
        variants.add(simple_0);
        variants.add(simple_1);
        variants.add(simple_2);
        variants.add(detailed_0);
        variants.add(detailed_1);
        variants.add(aer);
        variants.add(dwarf);
        variants.add(ygnar);
    }

    public static class Variant {
        public final String name;
        public final String registryName;
        public final String langPrefix;
        private ModelWaystone block = null;
        public final VoxelShape shape;
        public final float modelYOffset;

        public Variant(String name, String langPrefix, VoxelShape shape, float modelYOffset) {
            this.name = name;
            this.registryName = "waystone_model_" + name;
            this.langPrefix = langPrefix;
            this.shape = shape;
            this.modelYOffset = modelYOffset;
        }

        public ModelWaystone createBlock() {
            assert (this.block == null);
            this.block = new ModelWaystone(this);
            return this.block;
        }

        public ModelWaystone getBlock() {
            assert (this.block != null);
            return this.block;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Variant && this.name.equals(((Variant)o).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

