/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block;

import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.block.tiles.WaystoneGeneratorEntity;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.registry.BlockRegistry;
import gollorum.signpost.minecraft.worldgen.VillageGenUtils;
import gollorum.signpost.minecraft.worldgen.VillageWaystone;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.worldgen.VillageNamesProvider;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaystoneGeneratorBlock
extends BaseEntityBlock {
    public static final DirectionProperty Facing = BlockStateProperties.f_61374_;
    public static final String REGISTRY_NAME = "waystone_generator";

    public WaystoneGeneratorBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_));
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new WaystoneGeneratorEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{Facing});
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)Facing, (Comparable)context.m_8125_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            WaystoneGeneratorBlock.generate(state, pos, l, true);
        }
        return InteractionResult.CONSUME;
    }

    public static void generate(BlockState state, BlockPos pos, ServerLevel level, boolean manuallyPlaced) {
        if (!level.m_8055_(pos).m_60713_((Block)BlockRegistry.WaystoneGenerator.get())) {
            return;
        }
        if (!WaystoneGeneratorBlock.tryPlace(state, pos, level, manuallyPlaced)) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 18);
        }
    }

    private static boolean tryPlace(BlockState state, BlockPos pos, ServerLevel serverLevel, boolean manuallyPlaced) {
        BlockPos villageLocation = VillageGenUtils.getVillageLocationFor(serverLevel, pos, manuallyPlaced ? 0 : 512);
        List<ModelWaystone> allowedWaystones = WaystoneGeneratorBlock.getAllowedWaystones();
        if (allowedWaystones.size() == 0) {
            Signpost.LOGGER.warn("Tried to generate a waystone, but the list of allowed waystones was empty.");
            return false;
        }
        Direction facing = (Direction)state.m_61143_((Property)Facing);
        ModelWaystone waystone = WaystoneGeneratorBlock.getWaystoneType(new Random(serverLevel.m_7328_() ^ pos.m_121878_()), allowedWaystones);
        Optional<String> optionalName = VillageNamesProvider.requestFor(pos, villageLocation, serverLevel, new Random(serverLevel.m_7328_() ^ villageLocation.m_121878_()));
        if (optionalName.isEmpty()) {
            Signpost.LOGGER.warn("No name could be generated for waystone at " + pos + ".");
            return false;
        }
        String name = optionalName.get();
        boolean isWater = serverLevel.m_46801_(pos.m_7494_());
        serverLevel.m_7731_(pos, (BlockState)((BlockState)waystone.m_49966_().m_61124_((Property)WaystoneBlock.FACING, (Comparable)facing)).m_61124_((Property)ModelWaystone.Waterlogged, (Comparable)Boolean.valueOf(isWater)), 18);
        WaystoneLibrary.getInstance().update(name, WaystoneGeneratorBlock.locationDataFor(pos, serverLevel, facing), null, false);
        VillageWaystone.register(name, villageLocation, serverLevel, pos);
        return true;
    }

    private static List<ModelWaystone> getAllowedWaystones() {
        return ModelWaystone.variants.stream().filter(v -> Config.Server.worldGen.allowedVillageWaystones().contains(v.name)).map(ModelWaystone.Variant::getBlock).collect(Collectors.toList());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        if (!state.m_61138_((Property)Facing)) {
            return state;
        }
        return (BlockState)state.m_61124_((Property)Facing, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)Facing)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        if (!state.m_61138_((Property)Facing)) {
            return state;
        }
        return (BlockState)state.m_61124_((Property)Facing, (Comparable)((Direction)state.m_61143_((Property)Facing)).m_122424_());
    }

    private static WaystoneLocationData locationDataFor(BlockPos pos, ServerLevel world, Direction facing) {
        return new WaystoneLocationData(new WorldLocation(pos, (Level)world.m_6018_()), WaystoneGeneratorBlock.spawnPosFor(world, pos, facing));
    }

    private static Vector3 spawnPosFor(ServerLevel world, BlockPos waystonePos, Direction facing) {
        int offset;
        BlockPos spawnBlockPos = waystonePos.m_5484_(facing, -2);
        int maxOffset = 10;
        for (offset = 0; WaystoneGeneratorBlock.isFree(world.m_8055_(spawnBlockPos), world, spawnBlockPos) && offset <= maxOffset; ++offset) {
            spawnBlockPos = spawnBlockPos.m_7495_();
        }
        for (offset = 0; !WaystoneGeneratorBlock.isFree(world.m_8055_(spawnBlockPos), world, spawnBlockPos) && offset <= maxOffset; ++offset) {
            spawnBlockPos = spawnBlockPos.m_7494_();
        }
        return Vector3.fromBlockPos(spawnBlockPos).add(0.5f, 0.0f, 0.5f);
    }

    private static boolean isFree(BlockState state, ServerLevel world, BlockPos waystonePos) {
        return state.m_60812_((BlockGetter)world, waystonePos).m_83281_();
    }

    private static ModelWaystone getWaystoneType(Random random, List<ModelWaystone> allowedWaystones) {
        return allowedWaystones.get(random.nextInt(allowedWaystones.size()));
    }
}

