/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.data;

import gollorum.signpost.minecraft.data.BlockModels;
import gollorum.signpost.minecraft.data.BlockStates;
import gollorum.signpost.minecraft.data.BlockTags;
import gollorum.signpost.minecraft.data.ItemModels;
import gollorum.signpost.minecraft.data.ItemTags;
import gollorum.signpost.minecraft.data.LootTables;
import gollorum.signpost.minecraft.data.Recipes;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class DataGeneration {
    private DataGeneration() {
    }

    public static void register(IEventBus modBus) {
        modBus.register((Object)new DataGeneration());
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        DataGenerator datagenerator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        PackOutput output = event.getGenerator().getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeServer()) {
            BlockTags blocksTagProvider = new BlockTags(output, lookupProvider, fileHelper);
            datagenerator.addProvider(true, (DataProvider)blocksTagProvider);
            datagenerator.addProvider(true, (DataProvider)new ItemTags(output, lookupProvider, blocksTagProvider, fileHelper));
            datagenerator.addProvider(true, (DataProvider)new Recipes(output));
            datagenerator.addProvider(true, (DataProvider)new LootTables(output));
        }
        if (event.includeClient()) {
            BlockModels blockModelProvider = new BlockModels(datagenerator, output, fileHelper);
            datagenerator.addProvider(true, (DataProvider)blockModelProvider);
            datagenerator.addProvider(true, (DataProvider)new ItemModels(blockModelProvider, output, fileHelper));
            datagenerator.addProvider(true, (DataProvider)new BlockStates(output, fileHelper, blockModelProvider.postModelProvider, blockModelProvider.waystoneModelProvider, blockModelProvider.generatorModelProvider));
        }
    }
}

