/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import gollorum.signpost.minecraft.gui.utils.Flippable;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.rendering.FlippableModel;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.renderer.RenderType;
import org.joml.AxisAngle4d;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class GuiModelRenderer
implements Renderable,
Flippable {
    private final FlippableModel model;
    private final float modelSpaceXOffset;
    private final float modelSpaceYOffset;
    private boolean isFlipped = false;
    private final Point center;
    private final int width;
    private final int height;
    public final Rect rect;
    private final RenderType renderType;
    private final int[] tints;

    public GuiModelRenderer(Rect rect, FlippableModel model, float modelSpaceXOffset, float modelSpaceYOffset, RenderType renderType, int[] tints) {
        this.rect = rect;
        this.center = rect.center();
        this.width = rect.width;
        this.height = rect.height;
        this.model = model;
        this.modelSpaceXOffset = modelSpaceXOffset;
        this.modelSpaceYOffset = modelSpaceYOffset;
        this.renderType = renderType;
        this.tints = tints;
    }

    @Override
    public boolean isFlipped() {
        return this.isFlipped;
    }

    @Override
    public void setFlipped(boolean isFlipped) {
        this.isFlipped = isFlipped;
    }

    public void m_86412_(@Nonnull PoseStack unused, int mouseX, int mouseY, float partialTicks) {
        float scale = Math.min(this.width, this.height);
        PoseStack matrixStack = new PoseStack();
        RenderSystem.m_69478_();
        RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
            matrixStack.m_252880_(0.0f, 0.0f, -10.0f);
            if (this.isFlipped) {
                matrixStack.m_252781_(new Quaternionf(new AxisAngle4d(Math.PI, new Vector3f(0.0f, 1.0f, 0.0f))));
            }
            RenderingUtil.renderGui(this.model.get(this.isFlipped), new PoseStack(), this.tints, this.center, Angle.ZERO, Angle.ZERO, this.isFlipped, scale, new Vector3(this.modelSpaceXOffset, this.modelSpaceYOffset, 0.0f), this.renderType, m -> {});
        });
    }
}

