/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.items;

import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.registry.ItemRegistry;
import gollorum.signpost.utils.Tuple;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegistryObject;

public class CreativeModeTabEventListeners {
    private static CreativeModeTab _signpostTab;

    public static void register(IEventBus bus) {
        bus.register(CreativeModeTabEventListeners.class);
    }

    @SubscribeEvent
    public static void onRegisterTab(CreativeModeTabEvent.Register event) {
        _signpostTab = event.registerCreativeModeTab(new ResourceLocation("signpost", "signpost"), b -> b.m_257737_(() -> new ItemStack((ItemLike)ItemRegistry.POSTS_ITEMS.get(0).get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.signpost")));
    }

    @SubscribeEvent
    public static void onBuildCreativeModeContents(CreativeModeTabEvent.BuildContents event) {
        if (event.getTab() == _signpostTab) {
            event.accept(ItemRegistry.BRUSH);
            event.accept(ItemRegistry.WRENCH);
            for (RegistryObject<Item> registryObject : ItemRegistry.POSTS_ITEMS) {
                event.accept(registryObject);
            }
            event.accept(ItemRegistry.WAYSTONE_ITEM);
            for (Tuple tuple : ItemRegistry.ModelWaystoneItems) {
                if (!((List)Config.Server.allowedWaystones.get()).contains(((ModelWaystone.Variant)tuple._1).name)) continue;
                event.accept((Supplier)tuple._2);
            }
        }
        if (event.getTab() == CreativeModeTabs.f_256837_) {
            event.accept(ItemRegistry.WaystoneGeneratorItem);
            event.accept(ItemRegistry.GENERATION_WAND);
        }
    }
}

