/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Transformation;
import gollorum.signpost.minecraft.data.PostModel;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.util.Lazy;
import org.apache.commons.lang3.NotImplementedException;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class RenderingUtil {
    private static final ModelBakery modelBakery = Minecraft.m_91087_().m_91304_().getModelBakery();
    private static final ModelBaker modelBaker = new ModelBakery.ModelBakerImpl(modelBakery, (l, r) -> {
        throw new NotImplementedException();
    }, null);
    public static final Lazy<ModelBlockRenderer> Renderer = Lazy.of(() -> Minecraft.m_91087_().m_91289_().m_110937_());

    public static BakedModel loadModel(ResourceLocation location) {
        return modelBakery.m_119341_(location).m_7611_(modelBaker, m -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(m.m_119193_()).apply(m.m_119203_()), (ModelState)new SimpleModelState(Transformation.m_121093_()), location);
    }

    public static BakedModel loadModel(ResourceLocation modelLocation, ResourceLocation textureLocation) {
        ResourceLocation textLoc = RenderingUtil.trim(textureLocation);
        return modelBakery.m_119341_(modelLocation).m_7611_(modelBaker, m -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(m.m_119193_()).apply(textLoc), (ModelState)new SimpleModelState(Transformation.m_121093_()), modelLocation);
    }

    public static BakedModel loadModel(ResourceLocation modelLocation, ResourceLocation textureLocation1, ResourceLocation textureLocation2) {
        ResourceLocation textLoc1 = RenderingUtil.trim(textureLocation1);
        ResourceLocation textLoc2 = RenderingUtil.trim(textureLocation2);
        return modelBakery.m_119341_(modelLocation).m_7611_(modelBaker, m -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(m.m_119193_()).apply(m.m_119203_().equals((Object)PostModel.mainTextureMarker) ? textLoc1 : textLoc2), (ModelState)new SimpleModelState(Transformation.m_121093_()), modelLocation);
    }

    public static ResourceLocation trim(ResourceLocation textureLocation) {
        if (textureLocation.m_135815_().startsWith("textures/")) {
            textureLocation = new ResourceLocation(textureLocation.m_135827_(), textureLocation.m_135815_().substring("textures/".length()));
        }
        if (textureLocation.m_135815_().endsWith(".png")) {
            textureLocation = new ResourceLocation(textureLocation.m_135827_(), textureLocation.m_135815_().substring(0, textureLocation.m_135815_().length() - ".png".length()));
        }
        return textureLocation;
    }

    public static void render(PoseStack blockToView, Matrix4f localToBlock, BakedModel model, Level world, BlockState state, BlockPos pos, VertexConsumer buffer, boolean checkSides, RandomSource random, long rand, int combinedOverlay, int[] tints) {
        RenderingUtil.wrapInMatrixEntry(blockToView, () -> RenderingUtil.tesselateBlock((BlockAndTintGetter)world, model, state, tints, pos, blockToView, localToBlock, buffer, checkSides, random, rand, combinedOverlay));
    }

    public static int drawString(Font fontRenderer, String text, Point point, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, int color, int maxWidth, boolean dropShadow) {
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        int textWidth = fontRenderer.m_92895_(text);
        float scale = Math.min(1.0f, (float)maxWidth / (float)textWidth);
        Matrix4f matrix4f = new Matrix4f();
        float f = (float)Rect.xCoordinateFor(point.x, maxWidth, xAlignment) + (float)maxWidth * 0.5f;
        int n = point.y;
        Objects.requireNonNull(fontRenderer);
        float f2 = Rect.yCoordinateFor(n, 9, yAlignment);
        Objects.requireNonNull(fontRenderer);
        Matrix4f matrix = matrix4f.translation(f, f2 + 9.0f * 0.5f, 100.0f);
        if (scale < 1.0f) {
            matrix.scale(scale, scale, scale);
        }
        float f3 = (float)(maxWidth - Math.min(maxWidth, textWidth)) * 0.5f;
        Objects.requireNonNull(fontRenderer);
        int i = fontRenderer.m_271703_(text, f3, (float)(-9) * 0.5f, color, dropShadow, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        buffer.m_109911_();
        return i;
    }

    public static void renderGui(BakedModel model, PoseStack matrixStack, int[] tints, Point center, Angle yaw, Angle pitch, boolean isFlipped, float scale, Vector3 offset, RenderType renderType, Consumer<PoseStack> alsoDo) {
        RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
            matrixStack.m_252880_((float)center.x, (float)center.y, 0.0f);
            matrixStack.m_85841_(scale, -scale, scale);
            matrixStack.m_252781_(new Quaternionf(new AxisAngle4f(pitch.radians(), (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f))));
            if (isFlipped) {
                matrixStack.m_252781_(new Quaternionf(new AxisAngle4d(Math.PI, new Vector3f(0.0f, 1.0f, 0.0f))));
            }
            MultiBufferSource.BufferSource renderTypeBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
            RenderingUtil.renderGui(model, matrixStack, tints, offset, yaw, renderTypeBuffer.m_6299_(renderType), renderType, 0xF000F0, OverlayTexture.f_118083_, alsoDo);
            renderTypeBuffer.m_109911_();
        });
    }

    public static void renderGui(BakedModel model, PoseStack matrixStack, int[] tints, Vector3 offset, Angle yaw, VertexConsumer builder, RenderType renderType, int combinedLight, int combinedOverlay, Consumer<PoseStack> alsoDo) {
        RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
            matrixStack.m_252781_(new Quaternionf(new AxisAngle4f(yaw.radians(), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f))));
            matrixStack.m_252880_(offset.x, offset.y, offset.z);
            RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
                ArrayList<Direction> allDirections = new ArrayList<Direction>(Arrays.asList(Direction.values()));
                allDirections.add(null);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
                Minecraft.m_91087_().m_91097_().m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
                RandomSource random = RandomSource.m_216327_();
                for (Direction dir : allDirections) {
                    random.m_188584_(42L);
                    for (BakedQuad quad : model.getQuads(null, dir, random, ModelData.EMPTY, renderType)) {
                        float r = 1.0f;
                        float g = 1.0f;
                        float b = 1.0f;
                        if (quad.m_111304_()) {
                            int tint = tints[quad.m_111305_()];
                            r *= (float)Colors.getRed(tint) / 255.0f;
                            g *= (float)Colors.getGreen(tint) / 255.0f;
                            b *= (float)Colors.getBlue(tint) / 255.0f;
                        }
                        builder.m_85987_(matrixStack.m_85850_(), quad, r, g, b, combinedLight, combinedOverlay);
                    }
                }
            });
            alsoDo.accept(matrixStack);
        });
    }

    public static void wrapInMatrixEntry(PoseStack matrixStack, Runnable thenDo) {
        matrixStack.m_85836_();
        thenDo.run();
        matrixStack.m_85849_();
    }

    private static boolean tesselateBlock(BlockAndTintGetter level, BakedModel model, BlockState state, int[] tints, BlockPos pos, PoseStack blockToView, Matrix4f localToBlock, VertexConsumer vertexConsumer, boolean checkSides, RandomSource random, long combinedLight, int combinedOverlay) {
        boolean useAmbientOcclusion = Minecraft.m_91086_() && state.getLightEmission((BlockGetter)level, pos) == 0 && model.m_7541_();
        Vec3 vec3 = state.m_60824_((BlockGetter)level, pos);
        blockToView.m_85837_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        ModelData modelData = model.getModelData(level, pos, state, ModelData.EMPTY);
        try {
            return RenderingUtil.tesselate(level, model, state, tints, pos, blockToView, localToBlock, vertexConsumer, checkSides, random, combinedLight, combinedOverlay, modelData, useAmbientOcclusion);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block model being tesselated");
            CrashReportCategory.m_178950_((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)level, (BlockPos)pos, (BlockState)state);
            crashreportcategory.m_128159_("Using AO", (Object)useAmbientOcclusion);
            throw new ReportedException(crashreport);
        }
    }

    public static boolean tesselate(BlockAndTintGetter level, BakedModel model, BlockState state, int[] tints, BlockPos pos, PoseStack blockToView, Matrix4f localToBlock, VertexConsumer vertexConsumer, boolean checkSides, RandomSource random, long combinedLight, int combinedOverlay, ModelData modelData, boolean useAmbientOcclusion) {
        boolean flag = false;
        float[] aoValues = useAmbientOcclusion ? new float[LevelRenderer.f_109434_.length * 2] : null;
        BitSet bitset = new BitSet(3);
        ModelBlockRenderer.AmbientOcclusionFace aoFace = useAmbientOcclusion ? new ModelBlockRenderer.AmbientOcclusionFace() : null;
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        IQuadTransformer quadLocalToBlock = QuadTransformers.applying((Transformation)new Transformation(localToBlock));
        for (Direction direction : LevelRenderer.f_109434_) {
            random.m_188584_(combinedLight);
            List list = model.getQuads(state, direction, random, modelData, null);
            if (list.isEmpty()) continue;
            mutablePos.m_122159_((Vec3i)pos, direction);
            if (checkSides && !Block.m_152444_((BlockState)state, (BlockGetter)level, (BlockPos)pos, (Direction)direction, (BlockPos)mutablePos)) continue;
            if (useAmbientOcclusion) {
                RenderingUtil.renderModelFaceAO(level, state, tints, pos, blockToView, localToBlock, vertexConsumer, list, aoValues, bitset, aoFace, combinedOverlay, quadLocalToBlock);
            } else {
                RenderingUtil.renderModelWithoutAo(level, state, tints, pos, LevelRenderer.m_109537_((BlockAndTintGetter)level, (BlockState)state, (BlockPos)mutablePos), combinedOverlay, false, blockToView, localToBlock, vertexConsumer, list, bitset, quadLocalToBlock);
            }
            flag = true;
        }
        random.m_188584_(combinedLight);
        List quads = model.getQuads(state, null, random, modelData, null);
        if (!quads.isEmpty()) {
            if (useAmbientOcclusion) {
                RenderingUtil.renderModelFaceAO(level, state, tints, pos, blockToView, localToBlock, vertexConsumer, quads, aoValues, bitset, aoFace, combinedOverlay, quadLocalToBlock);
            } else {
                RenderingUtil.renderModelWithoutAo(level, state, tints, pos, -1, combinedOverlay, true, blockToView, localToBlock, vertexConsumer, quads, bitset, quadLocalToBlock);
            }
            flag = true;
        }
        return flag;
    }

    private static void renderModelFaceAO(BlockAndTintGetter level, BlockState state, int[] tints, BlockPos pos, PoseStack blockToView, Matrix4f localToBlock, VertexConsumer vertexConsumer, List<BakedQuad> quads, float[] aoFloats, BitSet bitset, ModelBlockRenderer.AmbientOcclusionFace aoFace, int combinedOverlay, IQuadTransformer quadLocalToBlock) {
        PoseStack.Pose poseMatrix = blockToView.m_85850_();
        for (BakedQuad bakedquad : quads) {
            bakedquad = RenderingUtil.transform(bakedquad, quadLocalToBlock, localToBlock);
            BakedQuad shadingQuad = RenderingUtil.clampWithinUnitCube(bakedquad);
            ((ModelBlockRenderer)Renderer.get()).m_111039_(level, state, pos, shadingQuad.m_111303_(), shadingQuad.m_111306_(), aoFloats, bitset);
            if (!ForgeHooksClient.calculateFaceWithoutAO((BlockAndTintGetter)level, (BlockState)state, (BlockPos)pos, (BakedQuad)bakedquad, (boolean)bitset.get(0), (float[])aoFace.f_111149_, (int[])aoFace.f_111150_)) {
                aoFace.m_111167_(level, state, pos, shadingQuad.m_111306_(), aoFloats, bitset, shadingQuad.m_111307_());
            }
            RenderingUtil.putQuadData(tints, vertexConsumer, poseMatrix, bakedquad, aoFace.f_111149_[0], aoFace.f_111149_[1], aoFace.f_111149_[2], aoFace.f_111149_[3], aoFace.f_111150_[0], aoFace.f_111150_[1], aoFace.f_111150_[2], aoFace.f_111150_[3], combinedOverlay);
        }
    }

    private static void renderModelWithoutAo(BlockAndTintGetter level, BlockState state, int[] tints, BlockPos pos, int lightColor, int combinedOverlay, boolean p_111007_, PoseStack blockToView, Matrix4f localToBlock, VertexConsumer vertexConsumer, List<BakedQuad> quads, BitSet bitSet, IQuadTransformer quadLocalToBlock) {
        PoseStack.Pose poseMatrix = blockToView.m_85850_();
        for (BakedQuad bakedquad : quads) {
            bakedquad = RenderingUtil.transform(bakedquad, quadLocalToBlock, localToBlock);
            if (p_111007_) {
                BakedQuad shadingQuad = RenderingUtil.clampWithinUnitCube(bakedquad);
                ((ModelBlockRenderer)Renderer.get()).m_111039_(level, state, pos, shadingQuad.m_111303_(), shadingQuad.m_111306_(), (float[])null, bitSet);
                BlockPos blockpos = bitSet.get(0) ? pos.m_121945_(shadingQuad.m_111306_()) : pos;
                lightColor = LevelRenderer.m_109537_((BlockAndTintGetter)level, (BlockState)state, (BlockPos)blockpos);
            }
            float f = level.m_7717_(bakedquad.m_111306_(), bakedquad.m_111307_());
            RenderingUtil.putQuadData(tints, vertexConsumer, poseMatrix, bakedquad, f, f, f, f, lightColor, lightColor, lightColor, lightColor, combinedOverlay);
        }
    }

    private static Direction transform(Direction dir, Matrix4f localPose) {
        Vec3i rawNormal = dir.m_122436_();
        Vector4f normal = new Vector4f((float)rawNormal.m_123341_(), (float)rawNormal.m_123342_(), (float)rawNormal.m_123343_(), 0.0f);
        normal.mul((Matrix4fc)localPose);
        return Direction.m_122372_((float)normal.x(), (float)normal.y(), (float)normal.z());
    }

    private static void putQuadData(int[] tints, VertexConsumer vertexConsumer, PoseStack.Pose pose, BakedQuad quad, float aor, float aog, float aob, float aoa, int lr, int lg, int lb, int la, int combinedOverlay) {
        float b;
        float g;
        float r;
        if (quad.m_111304_()) {
            int i = tints[quad.m_111305_()];
            r = (float)(i >> 16 & 0xFF) / 255.0f;
            g = (float)(i >> 8 & 0xFF) / 255.0f;
            b = (float)(i & 0xFF) / 255.0f;
        } else {
            r = 1.0f;
            g = 1.0f;
            b = 1.0f;
        }
        vertexConsumer.m_85995_(pose, quad, new float[]{aor, aog, aob, aoa}, r, g, b, new int[]{lr, lg, lb, la}, combinedOverlay, true);
    }

    private static BakedQuad transform(BakedQuad original, IQuadTransformer transformer, Matrix4f matrix4f) {
        BakedQuad copy = transformer.process(original);
        Direction dir = RenderingUtil.transform(original.m_111306_(), matrix4f);
        return new BakedQuad(copy.m_111303_(), copy.m_111305_(), dir, copy.m_173410_(), copy.m_111307_());
    }

    private static BakedQuad clampWithinUnitCube(BakedQuad quad) {
        int[] oldData = quad.m_111303_();
        int[] newData = new int[oldData.length];
        for (int i = 0; i < 4; ++i) {
            float x = Math.min(1.0f, Math.max(0.0f, Float.intBitsToFloat(oldData[i * 8])));
            float y = Math.min(1.0f, Math.max(0.0f, Float.intBitsToFloat(oldData[i * 8 + 1])));
            float z = Math.min(1.0f, Math.max(0.0f, Float.intBitsToFloat(oldData[i * 8 + 2])));
            newData[i * 8] = Float.floatToRawIntBits(x);
            newData[i * 8 + 1] = Float.floatToRawIntBits(y);
            newData[i * 8 + 2] = Float.floatToRawIntBits(z);
        }
        return new BakedQuad(newData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }
}

