/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import gollorum.signpost.minecraft.utils.tints.BlockColorTint;
import gollorum.signpost.minecraft.utils.tints.FluidTint;
import gollorum.signpost.minecraft.utils.tints.FoliageTint;
import gollorum.signpost.minecraft.utils.tints.GrassTint;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.StringSerializer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockAndTintGetter;

public interface Tint {
    public int getColorAt(BlockAndTintGetter var1, BlockPos var2);

    public static class Serialization
    implements CompoundSerializable<Tint> {
        private static final Map<String, CompoundSerializable<? extends Tint>> allSerializers = new HashMap<String, CompoundSerializable<? extends Tint>>();
        public static final Serialization instance;

        public static void register(String type, CompoundSerializable<? extends Tint> serializer) {
            allSerializers.put(type, serializer);
        }

        @Override
        public CompoundTag write(Tint tint, CompoundTag compound) {
            for (Map.Entry<String, CompoundSerializable<? extends Tint>> e : allSerializers.entrySet()) {
                if (tint.getClass() != e.getValue().getTargetClass()) continue;
                compound.m_128359_("Type", e.getKey());
                e.getValue().write(tint, compound);
                return compound;
            }
            throw new RuntimeException("Failed to serialize tint type " + tint.getClass());
        }

        @Override
        public boolean isContainedIn(CompoundTag compound) {
            return compound.m_128441_("Type") && allSerializers.containsKey(compound.m_128461_("Type"));
        }

        @Override
        public Tint read(CompoundTag compound) {
            return allSerializers.get(compound.m_128461_("Type")).read(compound);
        }

        @Override
        public void write(Tint tint, FriendlyByteBuf buffer) {
            for (Map.Entry<String, CompoundSerializable<? extends Tint>> e : allSerializers.entrySet()) {
                if (tint.getClass() != e.getValue().getTargetClass()) continue;
                StringSerializer.instance.write(e.getKey(), buffer);
                e.getValue().write(tint, buffer);
                return;
            }
            throw new RuntimeException("Failed to serialize tint type " + tint.getClass());
        }

        @Override
        public Tint read(FriendlyByteBuf buffer) {
            return allSerializers.get(StringSerializer.instance.read(buffer)).read(buffer);
        }

        @Override
        public Class<Tint> getTargetClass() {
            return Tint.class;
        }

        static {
            FoliageTint.register();
            BlockColorTint.register();
            GrassTint.register();
            FluidTint.register();
            instance = new Serialization();
        }
    }
}

