/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.BlockRestrictions;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.compat.Compat;
import gollorum.signpost.compat.ExternalWaystoneLibrary;
import gollorum.signpost.minecraft.block.BlockEventListener;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.commands.WaystoneArgument;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.data.DataGeneration;
import gollorum.signpost.minecraft.registry.BlockRegistry;
import gollorum.signpost.minecraft.registry.CreativeModeTabRegistry;
import gollorum.signpost.minecraft.registry.ItemRegistry;
import gollorum.signpost.minecraft.registry.LootItemConditionRegistry;
import gollorum.signpost.minecraft.registry.LootProviderRegistry;
import gollorum.signpost.minecraft.registry.RecipeRegistry;
import gollorum.signpost.minecraft.registry.TileEntityRegistry;
import gollorum.signpost.minecraft.rendering.PostRenderer;
import gollorum.signpost.minecraft.worldgen.JigsawDeserializers;
import gollorum.signpost.minecraft.worldgen.WaystoneDiscoveryEventListener;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.ServerType;
import gollorum.signpost.worldgen.Villages;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="signpost")
public class Signpost {
    public static final String MOD_ID = "signpost";
    public static final Logger LOGGER = LogManager.getLogger();
    private static MinecraftServer serverInstance;

    public static MinecraftServer getServerInstance() {
        return serverInstance;
    }

    public static ServerType getServerType() {
        return serverInstance == null ? ServerType.ConnectedClient : (serverInstance.m_6982_() ? ServerType.Dedicated : ServerType.HostingClient);
    }

    public Signpost() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        forgeBus.register((Object)new ForgeEvents());
        modBus.register((Object)new ModBusEvents());
        BlockRegistry.register(modBus);
        ItemRegistry.register(modBus);
        RecipeRegistry.register(modBus);
        TileEntityRegistry.register(modBus);
        DataGeneration.register(modBus);
        BlockEventListener.register(forgeBus);
        CreativeModeTabRegistry.register(modBus);
        WaystoneDiscoveryEventListener.register(forgeBus);
        Config.register();
        LootProviderRegistry.register(modBus);
        LootItemConditionRegistry.register(modBus);
        WaystoneArgument.register(modBus);
        Compat.register();
    }

    private static class ForgeEvents {
        private ForgeEvents() {
        }

        @SubscribeEvent
        public void serverAboutToStart(ServerAboutToStartEvent e) {
            serverInstance = e.getServer();
            WaystoneLibrary.initialize();
            BlockRestrictions.initialize();
            Villages.instance.initialize((RegistryAccess)e.getServer().m_206579_());
            WaystoneDiscoveryEventListener.initialize();
        }

        @SubscribeEvent
        public void joinServer(PlayerEvent.PlayerLoggedInEvent e) {
            if (!e.getEntity().m_9236_().f_46443_ && serverInstance.m_6982_()) {
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)e.getEntity()), new JoinServerEvent.Package());
            }
        }

        @SubscribeEvent
        public void onServerStopped(ServerStoppedEvent event) {
            serverInstance = null;
        }

        @SubscribeEvent
        public void onWorldLoad(LevelEvent.Load event) {
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)levelAccessor;
                if (((ServerLevel)event.getLevel()).m_46472_().equals((Object)Level.f_46428_)) {
                    if (!WaystoneLibrary.getInstance().hasStorageBeenSetup()) {
                        WaystoneLibrary.getInstance().setupStorage(world);
                    }
                    if (!BlockRestrictions.getInstance().hasStorageBeenSetup()) {
                        BlockRestrictions.getInstance().setupStorage(world);
                    }
                }
            }
        }
    }

    private static class ModBusEvents {
        private ModBusEvents() {
        }

        @SubscribeEvent
        public void setup(FMLCommonSetupEvent event) {
            PacketHandler.initialize();
            PacketHandler.register(new JoinServerEvent(), -50);
            ExternalWaystoneLibrary.initialize();
            WaystoneLibrary.registerNetworkPackets();
            JigsawDeserializers.register();
        }

        @SubscribeEvent
        public void doClientStuff(FMLClientSetupEvent event) {
            BlockEntityRenderers.m_173590_(PostTile.getBlockEntityType(), PostRenderer::new);
        }
    }

    private static final class JoinServerEvent
    implements PacketHandler.Event<Package> {
        private JoinServerEvent() {
        }

        @Override
        public Class<Package> getMessageClass() {
            return Package.class;
        }

        @Override
        public void encode(Package message, FriendlyByteBuf buffer) {
        }

        @Override
        public Package decode(FriendlyByteBuf buffer) {
            return new Package();
        }

        @Override
        public void handle(Package message, NetworkEvent.Context context) {
            WaystoneLibrary.initialize();
        }

        public static final class Package {
        }
    }
}

