/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block;

import gollorum.signpost.BlockRestrictions;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.block.tiles.WaystoneTile;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.gui.RequestWaystoneGui;
import gollorum.signpost.minecraft.utils.TextComponents;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.security.WithCountRestriction;
import gollorum.signpost.utils.Delay;
import gollorum.signpost.utils.WaystoneData;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.PacketDistributor;

public class WaystoneBlock
extends BaseEntityBlock
implements WithCountRestriction {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final String REGISTRY_NAME = "waystone";
    private static WaystoneBlock instance = null;

    public static WaystoneBlock createInstance() {
        assert (instance == null);
        instance = new WaystoneBlock();
        return instance;
    }

    public static WaystoneBlock getInstance() {
        assert (instance != null);
        return instance;
    }

    private WaystoneBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(1.5f, 6.0f));
    }

    public static void openGuiIfHasPermission(ServerPlayer player, WorldLocation worldLocation) {
        assert (Signpost.getServerType().isServer);
        Optional<WaystoneData> data = WaystoneLibrary.getInstance().getHandleByLocation(worldLocation).flatMap(WaystoneLibrary.getInstance()::getData);
        boolean wantsToOpenGui = data.isEmpty() || WaystoneLibrary.getInstance().isDiscovered(PlayerHandle.from((Entity)player), ((WaystoneData)data.get()).handle);
        boolean mayOpenGui = data.map(d -> d.hasThePermissionToEdit((Player)player)).orElse(true);
        if (wantsToOpenGui && mayOpenGui) {
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new RequestWaystoneGui.Package(worldLocation, data));
        } else {
            WaystoneBlock.discover(player, (WaystoneData)data.get());
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        WaystoneBlock.onRightClick(world, pos, player);
        return InteractionResult.CONSUME;
    }

    public static void onRightClick(Level world, BlockPos pos, Player player) {
        if (!world.m_5776_() && player instanceof ServerPlayer) {
            WaystoneBlock.openGuiIfHasPermission((ServerPlayer)player, new WorldLocation(pos, world));
        }
    }

    private static void discover(ServerPlayer player, WaystoneData data) {
        if (WaystoneLibrary.getInstance().addDiscovered(new PlayerHandle(player.m_20148_()), data.handle)) {
            player.m_213846_((Component)Component.m_237110_((String)"signpost.discovered", (Object[])new Object[]{TextComponents.waystone(player, data.name)}));
        }
    }

    public static void discover(PlayerHandle player, WaystoneData data) {
        ServerPlayer playerEntity;
        assert (Signpost.getServerType().isServer);
        if (WaystoneLibrary.getInstance().addDiscovered(player, data.handle) && (playerEntity = player.asEntity()) != null) {
            playerEntity.m_213846_((Component)Component.m_237110_((String)"signpost.discovered", (Object[])new Object[]{TextComponents.waystone(playerEntity, data.name)}));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WaystoneTile(pos, state);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        WaystoneBlock.registerOwnerAndRequestGui(world, pos, placer, stack);
    }

    public static void registerOwnerAndRequestGui(Level world, BlockPos pos, LivingEntity placer, ItemStack stack) {
        Delay.forFrames(6, world.m_5776_(), () -> TileEntityUtils.delayUntilTileEntityExists((LevelAccessor)world, pos, WaystoneTile.getBlockEntityType(), t -> {
            t.setWaystoneOwner(Optional.of(PlayerHandle.from((Entity)placer)));
            if (placer instanceof ServerPlayer) {
                WorldLocation worldLocation = new WorldLocation(pos, world);
                boolean wasRegistered = WaystoneBlock.getCustomName(stack).map(name -> {
                    WaystoneLocationData locationData = new WaystoneLocationData(worldLocation, Vector3.fromVec3d(placer.m_20182_()));
                    CompoundTag handleTag = stack.m_41737_("Handle");
                    Optional<WaystoneHandle.Vanilla> handle = handleTag != null ? Optional.of(WaystoneHandle.Vanilla.Serializer.read(handleTag)) : Optional.empty();
                    return WaystoneLibrary.getInstance().tryAddNew((String)name, locationData, (ServerPlayer)placer, handle);
                }).orElse(false);
                if (!wasRegistered) {
                    PacketHandler.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)placer), new RequestWaystoneGui.Package(worldLocation, Optional.empty()));
                }
            }
        }, 100, Optional.empty()));
    }

    private static Optional<String> getCustomName(ItemStack stack) {
        CompoundTag displayTag = stack.m_41737_("display");
        if (displayTag != null && displayTag.m_128425_("Name", 8)) {
            try {
                MutableComponent component = Component.Serializer.m_130701_((String)displayTag.m_128461_("Name"));
                if (component != null) {
                    return Optional.of(component.getString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public BlockRestrictions.Type getBlockRestrictionType() {
        return BlockRestrictions.Type.Waystone;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6786_(LevelAccessor world, BlockPos pos, BlockState state) {
        super.m_6786_(world, pos, state);
        if (!world.m_5776_() && world instanceof Level) {
            WaystoneTile.onRemoved((ServerLevel)world, pos);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return WaystoneBlock.fillClonedItemStack(super.getCloneItemStack(state, target, level, pos, player), level, pos, player);
    }

    public static ItemStack fillClonedItemStack(ItemStack stack, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity untypedEntity = level.m_7702_(pos);
        if (untypedEntity instanceof WaystoneTile) {
            WaystoneTile tile = (WaystoneTile)untypedEntity;
            if (player.m_20310_(((Integer)Config.Server.permissions.pickUnownedWaystonePermissionLevel.get()).intValue()) || tile.getWaystoneOwner().map(o -> o.equals(PlayerHandle.from((Entity)player))).orElse(true).booleanValue()) {
                tile.getHandle().ifPresent(h -> stack.m_41700_("Handle", (Tag)WaystoneHandle.Vanilla.Serializer.write((WaystoneHandle.Vanilla)h)));
                tile.getName().ifPresent(n -> stack.m_41714_((Component)Component.m_237113_((String)n)));
            }
        }
        return stack;
    }
}

