/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.data;

import com.google.common.collect.ImmutableList;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.storage.loot.PermissionCheck;
import gollorum.signpost.minecraft.storage.loot.RegisteredWaystoneLootNbtProvider;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class LootTables
extends LootTableProvider {
    public LootTables(PackOutput packOutput) {
        super(packOutput, Set.of(), VanillaLootTableProvider.m_247452_((PackOutput)packOutput).getTables());
    }

    public List<LootTableProvider.SubProviderEntry> getTables() {
        return ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(() -> this::generateBlockLootTables, LootContextParamSets.f_81421_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
    }

    private void generateBlockLootTables(BiConsumer<ResourceLocation, LootTable.Builder> builder) {
        for (PostBlock.Variant variant : PostBlock.AllVariants) {
            builder.accept(new ResourceLocation("signpost", "blocks/" + ForgeRegistries.BLOCKS.getKey((Object)variant.getBlock()).m_135815_()), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)variant.getBlock()).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Parts", "Parts")).m_79080_(BlockLootSubProvider.f_243678_)).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)variant.getBlock())))));
        }
        builder.accept(new ResourceLocation("signpost", "blocks/" + ForgeRegistries.BLOCKS.getKey((Object)WaystoneBlock.getInstance()).m_135815_()), this.mkWaystoneLootTable((Block)WaystoneBlock.getInstance()));
        for (ModelWaystone.Variant variant : ModelWaystone.variants) {
            builder.accept(new ResourceLocation("signpost", "blocks/" + ForgeRegistries.BLOCKS.getKey((Object)variant.getBlock()).m_135815_()), this.mkWaystoneLootTable((Block)variant.getBlock()));
        }
    }

    private LootTable.Builder mkWaystoneLootTable(Block block) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)new RegisteredWaystoneLootNbtProvider()).m_80279_("Handle", "Handle").m_80282_("display", "display", CopyNbtFunction.MergeStrategy.MERGE)).m_79080_(BlockLootSubProvider.f_243678_)).m_79080_((LootItemCondition.Builder)new PermissionCheck.Builder(PermissionCheck.Type.CanPickWaystone))).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block))));
    }
}

