/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.data;

import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.LargeSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.data.BlockModels;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.modelGeneration.SignModelFactory;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public class PostModel {
    private static final String texturePost = "post";
    public static final String textureSign = "texture";
    public static final ResourceLocation mainTextureMarker = PostBlock.ModelType.Oak.mainTexture.location();
    public static final String secondaryTexture = "secondary_texture";
    private static final ResourceLocation previewLocation = new ResourceLocation("signpost", "block/post_preview");
    public static final ResourceLocation postLocation = new ResourceLocation("signpost", "block/post_only");
    public static final ResourceLocation wideLocation = new ResourceLocation("signpost", "block/small_wide_sign");
    public static final ResourceLocation wideFlippedLocation = new ResourceLocation("signpost", wideLocation.m_135815_() + "_flipped");
    public static final ResourceLocation shortLocation = new ResourceLocation("signpost", "block/small_short_sign");
    public static final ResourceLocation shortFlippedLocation = new ResourceLocation("signpost", shortLocation.m_135815_() + "_flipped");
    public static final ResourceLocation largeLocation = new ResourceLocation("signpost", "block/large_sign");
    public static final ResourceLocation largeFlippedLocation = new ResourceLocation("signpost", largeLocation.m_135815_() + "_flipped");
    public static final ResourceLocation wideOverlayLocation = new ResourceLocation("signpost", "block/small_wide_sign_overlay");
    public static final ResourceLocation wideOverlayFlippedLocation = new ResourceLocation("signpost", wideOverlayLocation.m_135815_() + "_flipped");
    public static final ResourceLocation shortOverlayLocation = new ResourceLocation("signpost", "block/small_short_sign_overlay");
    public static final ResourceLocation shortOverlayFlippedLocation = new ResourceLocation("signpost", shortOverlayLocation.m_135815_() + "_flipped");
    public static final ResourceLocation largeOverlayLocation = new ResourceLocation("signpost", "block/large_sign_overlay");
    public static final ResourceLocation largeOverlayFlippedLocation = new ResourceLocation("signpost", largeOverlayLocation.m_135815_() + "_flipped");
    public final Map<PostBlock.Variant, BlockModelBuilder> allModels;
    private static final ModelBuilder.FaceRotation mainTextureRotation = ModelBuilder.FaceRotation.CLOCKWISE_90;
    private static final ModelBuilder.FaceRotation secondaryTextureRotation = ModelBuilder.FaceRotation.CLOCKWISE_90;
    private final BlockModelBuilder previewModel;
    private final BlockModels blockModelProvider;

    public PostModel(BlockModels blockModelProvider) {
        this.previewModel = new BlockModelBuilder(previewLocation, blockModelProvider.existingFileHelper);
        this.allModels = PostBlock.AllVariants.stream().collect(Collectors.toMap(i -> i, i -> new BlockModelBuilder(new ResourceLocation("signpost", "block/" + i.registryName), blockModelProvider.existingFileHelper)));
        this.blockModelProvider = blockModelProvider;
    }

    private BlockModelBuilder getBuilder(String path) {
        return (BlockModelBuilder)this.blockModelProvider.getBuilder(path);
    }

    public void registerModels() {
        BlockModelBuilder previewBuilder = (BlockModelBuilder)((BlockModelBuilder)this.getBuilder(previewLocation.toString()).parent((ModelFile)new ModelFile.ExistingModelFile(new ResourceLocation("block/block"), this.blockModelProvider.existingFileHelper))).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 315.0f, 0.0f).scale(0.625f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 315.0f, 0.0f).scale(0.4f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 315.0f, 0.0f).scale(0.4f).end().end();
        PostModel.makePostAt(new Vector3(8.0f, 8.0f, 8.0f), previewBuilder);
        new SignModelFactory<String>().makeWideSign(new Vector3(8.0f, 12.0f, 8.0f), "#texture", "#secondary_texture").build(previewBuilder, SignModelFactory.Builder.BlockModel);
        PostModel.makePostAt(new Vector3(0.0f, 8.0f, 0.0f), this.getBuilder(postLocation.toString())).texture(texturePost, PostBlock.ModelType.Oak.postTexture.location());
        this.buildDefaultAndFlipped(new SignModelFactory<String>().makeWideSign("#texture", "#secondary_texture"), wideLocation, wideFlippedLocation);
        this.buildDefaultAndFlipped(new SignModelFactory<String>().makeShortSign("#texture", "#secondary_texture"), shortLocation, shortFlippedLocation);
        this.buildDefaultAndFlipped(new SignModelFactory<String>().makeLargeSign("#texture", "#secondary_texture"), largeLocation, largeFlippedLocation);
        this.buildDefaultAndFlippedOverlay(new SignModelFactory<String>().makeWideSignOverlay("#texture"), wideOverlayLocation, wideOverlayFlippedLocation, Overlay.Gras.textureFor(SmallWideSignBlockPart.class));
        this.buildDefaultAndFlippedOverlay(new SignModelFactory<String>().makeShortSignOverlay("#texture"), shortOverlayLocation, shortOverlayFlippedLocation, Overlay.Gras.textureFor(SmallShortSignBlockPart.class));
        this.buildDefaultAndFlippedOverlay(new SignModelFactory<String>().makeLargeSignOverlay("#texture"), largeOverlayLocation, largeOverlayFlippedLocation, Overlay.Gras.textureFor(LargeSignBlockPart.class));
        for (PostBlock.Variant variant : PostBlock.AllVariants) {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(variant.registryName).parent((ModelFile)this.previewModel)).texture("particle", variant.type.postTexture.location())).texture(texturePost, variant.type.postTexture.location())).texture(textureSign, variant.type.mainTexture.location())).texture(secondaryTexture, variant.type.secondaryTexture.location());
        }
    }

    private void buildDefaultAndFlipped(SignModelFactory<String> factory, ResourceLocation main, ResourceLocation flipped) {
        ((BlockModelBuilder)factory.build(this.getBuilder(main.toString()), SignModelFactory.Builder.BlockModel).texture(textureSign, mainTextureMarker)).texture(secondaryTexture, PostBlock.ModelType.Oak.secondaryTexture.location());
        ((BlockModelBuilder)factory.build(this.getBuilder(flipped.toString()), SignModelFactory.Builder.BlockModelFlipped).texture(textureSign, mainTextureMarker)).texture(secondaryTexture, PostBlock.ModelType.Oak.secondaryTexture.location());
    }

    private void buildDefaultAndFlippedOverlay(SignModelFactory<String> factory, ResourceLocation main, ResourceLocation flipped, ResourceLocation texture) {
        factory.build(this.getBuilder(main.toString()), SignModelFactory.Builder.BlockModel).texture(textureSign, texture);
        factory.build(this.getBuilder(flipped.toString()), SignModelFactory.Builder.BlockModelFlipped).texture(textureSign, texture);
    }

    private static BlockModelBuilder makePostAt(Vector3 center, BlockModelBuilder builder) {
        builder.element().from(center.x - 2.0f, center.y - 8.0f, center.z - 2.0f).to(center.x + 2.0f, center.y + 8.0f, center.z + 2.0f).face(Direction.SOUTH).texture("#post").uvs(0.0f, 0.0f, 4.0f, 16.0f).tintindex(0).end().face(Direction.EAST).texture("#post").uvs(4.0f, 0.0f, 8.0f, 16.0f).tintindex(0).end().face(Direction.NORTH).texture("#post").uvs(8.0f, 0.0f, 12.0f, 16.0f).tintindex(0).end().face(Direction.WEST).texture("#post").uvs(12.0f, 0.0f, 16.0f, 16.0f).tintindex(0).end().face(Direction.DOWN).texture("#post").uvs(0.0f, 4.0f, 4.0f, 0.0f).tintindex(0).end().face(Direction.UP).texture("#post").uvs(0.0f, 16.0f, 4.0f, 12.0f).tintindex(0).end();
        return builder;
    }

    public static class Item {
        public static void registerModels(Function<String, ItemModelBuilder> getBuilder, PostModel postModelProvider) {
            for (Map.Entry<PostBlock.Variant, BlockModelBuilder> entry : postModelProvider.allModels.entrySet()) {
                ((ItemModelBuilder)getBuilder.apply(entry.getKey().registryName).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 35.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.625f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.25f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 180.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.5f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 135.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 315.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 315.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f).end().end();
            }
        }
    }
}

