/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.utils;

import gollorum.signpost.utils.Tint;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.OptionalSerializer;
import gollorum.signpost.utils.serialization.ResourceLocationSerializer;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public record Texture(ResourceLocation location, Optional<Tint> tint) {
    public static final CompoundSerializable<Texture> Serializer = new CompoundSerializable<Texture>(){

        @Override
        public CompoundTag write(Texture texture, CompoundTag compound) {
            ResourceLocationSerializer.Instance.write(texture.location, compound);
            compound.m_128365_("Tint", (Tag)Tint.Serialization.instance.optional().write(texture.tint));
            return compound;
        }

        @Override
        public boolean isContainedIn(CompoundTag compound) {
            return ResourceLocationSerializer.Instance.isContainedIn(compound) && compound.m_128441_("Tint");
        }

        @Override
        public Texture read(CompoundTag compound) {
            return new Texture(ResourceLocationSerializer.Instance.read(compound), (Optional<Tint>)((OptionalSerializer)Tint.Serialization.instance.optional()).read(compound.m_128469_("Tint")));
        }

        @Override
        public void write(Texture texture, FriendlyByteBuf buffer) {
            ResourceLocationSerializer.Instance.write(texture.location, buffer);
            Tint.Serialization.instance.optional().write(texture.tint, buffer);
        }

        @Override
        public Texture read(FriendlyByteBuf buffer) {
            return new Texture(ResourceLocationSerializer.Instance.read(buffer), (Optional<Tint>)Tint.Serialization.instance.optional().read(buffer));
        }

        @Override
        public Class<Texture> getTargetClass() {
            return Texture.class;
        }
    };

    public Texture(ResourceLocation location) {
        this(location, Optional.empty());
    }

    @Override
    public String toString() {
        return null;
    }

    public static Texture readFrom(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)tag;
            return Serializer.read(compound);
        }
        return new Texture(ResourceLocation.m_135820_((String)tag.m_7916_()));
    }
}

