/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.worldgen;

import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.utils.TextComponents;
import gollorum.signpost.minecraft.worldgen.VillageWaystone;
import gollorum.signpost.utils.WaystoneData;
import io.netty.util.internal.PlatformDependent;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WaystoneDiscoveryEventListener {
    private static final int discoveryDistance = 8;
    private static ConcurrentMap<ServerPlayer, ConcurrentMap<WaystoneHandle.Vanilla, BlockPos>> trackedPlayers;

    public static void register(IEventBus bus) {
        bus.register(WaystoneDiscoveryEventListener.class);
    }

    public static void initialize() {
        trackedPlayers = PlatformDependent.newConcurrentHashMap();
    }

    @SubscribeEvent
    public static void onWatchChunk(ChunkWatchEvent.Watch event) {
        if (!WaystoneLibrary.hasInstance()) {
            return;
        }
        VillageWaystone.ChunkEntryKey key = new VillageWaystone.ChunkEntryKey(event.getPos(), event.getPlayer().m_284548_().m_46472_().m_135782_());
        Map<VillageWaystone.ChunkEntryKey, WaystoneHandle.Vanilla> allEntries = VillageWaystone.getAllEntriesByChunk();
        WaystoneHandle.Vanilla handle = allEntries.get(key);
        if (handle != null && !WaystoneLibrary.getInstance().isDiscovered(PlayerHandle.from((Entity)event.getPlayer()), handle)) {
            Optional<WaystoneData> dataOption = WaystoneLibrary.getInstance().getData(handle);
            dataOption.ifPresentOrElse(data -> trackedPlayers.computeIfAbsent(event.getPlayer(), p -> PlatformDependent.newConcurrentHashMap()).putIfAbsent(handle, data.location.block.blockPos), () -> allEntries.remove(key));
        }
    }

    @SubscribeEvent
    public static void onUnWatchChunk(ChunkWatchEvent.UnWatch event) {
        ConcurrentMap set = (ConcurrentMap)trackedPlayers.get(event.getPlayer());
        if (set == null) {
            return;
        }
        WaystoneHandle.Vanilla handle = VillageWaystone.getAllEntriesByChunk().get(new VillageWaystone.ChunkEntryKey(event.getPos(), event.getPlayer().m_284548_().m_46472_().m_135782_()));
        if (handle == null) {
            return;
        }
        set.remove(handle);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (!WaystoneLibrary.hasInstance()) {
            return;
        }
        for (Map.Entry map : trackedPlayers.entrySet()) {
            for (Map.Entry inner : ((ConcurrentMap)map.getValue()).entrySet()) {
                if (!((BlockPos)inner.getValue()).m_123314_((Vec3i)((ServerPlayer)map.getKey()).m_20183_(), 8.0)) continue;
                WaystoneLibrary.getInstance().getData((WaystoneHandle.Vanilla)inner.getKey()).ifPresent(data -> {
                    if (WaystoneLibrary.getInstance().addDiscovered(new PlayerHandle((Entity)map.getKey()), (WaystoneHandle.Vanilla)inner.getKey())) {
                        ((ServerPlayer)map.getKey()).m_213846_((Component)Component.m_237110_((String)"signpost.discovered", (Object[])new Object[]{TextComponents.waystone((ServerPlayer)map.getKey(), data.name)}));
                    }
                });
                ((ConcurrentMap)map.getValue()).remove(inner.getKey());
            }
            if (!((ConcurrentMap)map.getValue()).isEmpty()) continue;
            trackedPlayers.remove(map.getKey());
        }
    }

    public static void registerNew(WaystoneHandle.Vanilla handle, ServerLevel world, BlockPos pos) {
        Signpost.getServerInstance().m_6846_().m_11314_().forEach(player -> {
            if (player.m_284548_().equals(world) && player.m_20183_().m_123314_((Vec3i)pos, 100.0)) {
                trackedPlayers.computeIfAbsent((ServerPlayer)player, p -> PlatformDependent.newConcurrentHashMap()).putIfAbsent(handle, pos);
            }
        });
    }
}

