/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.recipe.custom.Recipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.DummyPropertiesComponent;
import org.cyclops.cyclopscore.recipe.custom.component.ItemStackRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.ItemStacksRecipeComponent;
import org.cyclops.cyclopscore.recipe.event.IRecipeOutputObserver;
import org.cyclops.cyclopscore.recipe.event.ObservableShapedRecipe;
import org.cyclops.cyclopscore.recipe.xml.IRecipeConditionHandler;
import org.cyclops.cyclopscore.recipe.xml.IRecipeTypeHandler;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.block.BoxOfEternalClosure;
import org.cyclops.evilcraft.block.BoxOfEternalClosureConfig;
import org.cyclops.evilcraft.block.DarkTank;
import org.cyclops.evilcraft.block.DarkTankConfig;
import org.cyclops.evilcraft.block.DisplayStand;
import org.cyclops.evilcraft.block.DisplayStandConfig;
import org.cyclops.evilcraft.block.EntangledChalice;
import org.cyclops.evilcraft.block.EntangledChaliceConfig;
import org.cyclops.evilcraft.block.EntangledChaliceItem;
import org.cyclops.evilcraft.block.EnvironmentalAccumulator;
import org.cyclops.evilcraft.block.EnvironmentalAccumulatorConfig;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.core.item.ItemBlockFluidContainer;
import org.cyclops.evilcraft.core.recipe.BloodExtractorCombinationRecipe;
import org.cyclops.evilcraft.core.recipe.BroomPartCombinationRecipe;
import org.cyclops.evilcraft.core.recipe.DisplayStandRecipe;
import org.cyclops.evilcraft.core.recipe.ItemBlockFluidContainerCombinationRecipe;
import org.cyclops.evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeComponent;
import org.cyclops.evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeProperties;
import org.cyclops.evilcraft.core.recipe.xml.BloodInfuserRecipeTypeHandler;
import org.cyclops.evilcraft.core.recipe.xml.EnvironmentalAccumulatorRecipeTypeHandler;
import org.cyclops.evilcraft.core.weather.WeatherType;
import org.cyclops.evilcraft.enchantment.EnchantmentPoisonTip;
import org.cyclops.evilcraft.enchantment.EnchantmentPoisonTipConfig;
import org.cyclops.evilcraft.fluid.Poison;
import org.cyclops.evilcraft.fluid.PoisonConfig;
import org.cyclops.evilcraft.item.BiomeExtract;
import org.cyclops.evilcraft.item.BiomeExtractConfig;
import org.cyclops.evilcraft.item.BloodExtractorConfig;
import org.cyclops.evilcraft.item.BroomConfig;
import org.cyclops.evilcraft.item.CorruptedTearConfig;
import org.cyclops.evilcraft.item.DarkGem;
import org.cyclops.evilcraft.item.DarkGemConfig;
import org.cyclops.evilcraft.item.InvertedPotentia;
import org.cyclops.evilcraft.item.InvertedPotentiaConfig;
import org.cyclops.evilcraft.item.PotentiaSphereConfig;
import org.cyclops.evilcraft.item.VeinSword;
import org.cyclops.evilcraft.item.VeinSwordConfig;
import org.cyclops.evilcraft.item.VengeancePickaxe;
import org.cyclops.evilcraft.item.VengeancePickaxeConfig;
import org.cyclops.evilcraft.item.WeatherContainer;
import org.cyclops.evilcraft.item.WeatherContainerConfig;

public class ExtendedRecipeHandler
extends RecipeHandler {
    public ExtendedRecipeHandler(ModBase mod, String ... fileNames) {
        super(mod, fileNames);
    }

    protected void registerHandlers(Map<String, IRecipeTypeHandler> recipeTypeHandlers, Map<String, IRecipeConditionHandler> recipeConditionHandlers) {
        super.registerHandlers(recipeTypeHandlers, recipeConditionHandlers);
        recipeTypeHandlers.put("evilcraft:bloodinfuser", (IRecipeTypeHandler)new BloodInfuserRecipeTypeHandler());
        recipeTypeHandlers.put("evilcraft:environmentalaccumulator", (IRecipeTypeHandler)new EnvironmentalAccumulatorRecipeTypeHandler());
    }

    protected void registerRecipeSorters() {
        super.registerRecipeSorters();
        RecipeSorter.register((String)"evilcraftcontainercombination", ItemBlockFluidContainerCombinationRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapedore");
        RecipeSorter.register((String)"evilcraftbloodextractorcombination", BloodExtractorCombinationRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapedore");
        RecipeSorter.register((String)"evilcraftbroomcombination", BroomPartCombinationRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapedore");
        RecipeSorter.register((String)"evilcraftdisplaystand", DisplayStandRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:forge:shapedore");
    }

    protected void loadPredefineds(Map<String, ItemStack> predefinedItems, Set<String> predefinedValues) {
        super.loadPredefineds(predefinedItems, predefinedValues);
        if (Configs.isEnabled(EnchantmentPoisonTipConfig.class)) {
            ItemStack poisonTipEnchant = new ItemStack((Item)Items.field_151134_bR);
            EnchantmentPoisonTip enchant = EnchantmentPoisonTip.getInstance();
            Items.field_151134_bR.func_92115_a(poisonTipEnchant, new EnchantmentData((Enchantment)enchant, enchant.func_77319_d()));
            predefinedItems.put("evilcraft:enchanted_book_poisonTip", poisonTipEnchant);
        }
        if (Configs.isEnabled(WeatherContainerConfig.class)) {
            ItemStack lightningWeatherContainer = new ItemStack((Item)WeatherContainer.getInstance(), 1, WeatherContainer.WeatherContainerTypes.LIGHTNING.ordinal());
            predefinedItems.put("evilcraft:lightningWeatherContainer", lightningWeatherContainer);
        }
        if (Configs.isEnabled(InvertedPotentiaConfig.class)) {
            ItemStack invertedPotentiaEmpowered = new ItemStack((Item)InvertedPotentia.getInstance(), 1, 1);
            predefinedItems.put("evilcraft:invertedPotentiaEmpowered", invertedPotentiaEmpowered);
        }
        if (Configs.isEnabled(VengeancePickaxeConfig.class)) {
            ItemStack vengeancePickaxeFortune = VengeancePickaxe.createCraftingResult();
            predefinedItems.put("evilcraft:vengeancePickaxeFortune", vengeancePickaxeFortune);
        }
        if (Configs.isEnabled(BoxOfEternalClosureConfig.class)) {
            predefinedItems.put("evilcraft:boxOfEternalClosureFilled", BoxOfEternalClosure.boxOfEternalClosureFilled);
        }
        if (Configs.isEnabled(InvertedPotentiaConfig.class)) {
            ItemStack empoweredInvertedPotentia = new ItemStack((Item)InvertedPotentia.getInstance());
            InvertedPotentia.getInstance().empower(empoweredInvertedPotentia);
            predefinedItems.put("evilcraft:empoweredInvertedPotentia", empoweredInvertedPotentia);
        }
        if (Configs.isEnabled(DarkTankConfig.class)) {
            ItemStack darkTankx9 = new ItemStack((Block)DarkTank.getInstance());
            ItemBlockFluidContainer item = (ItemBlockFluidContainer)darkTankx9.func_77973_b();
            item.setCapacity(darkTankx9, item.getCapacity(darkTankx9) * 9);
            predefinedItems.put("evilcraft:darkTankx9", darkTankx9);
        }
        if (PotentiaSphereConfig.enderPearlRecipe) {
            predefinedValues.add("evilcraft:enderPearlRecipe");
        }
        if (Configs.isEnabled(VeinSwordConfig.class)) {
            ItemStack veinSwordLooting = VeinSword.createCraftingResult();
            predefinedItems.put("evilcraft:veinSwordLooting", veinSwordLooting);
        }
        if (WeatherContainerConfig.shapelessRecipes) {
            predefinedValues.add("evilcraft:shapelessRecipes");
        }
        if (Configs.isEnabled(BroomConfig.class)) {
            for (IBroomPart broomPart : BroomParts.REGISTRY.getParts()) {
                String id = String.format("%s:%s:%s", broomPart.getId().func_110624_b(), "broompart", broomPart.getId().func_110623_a());
                ItemStack itemStack = (ItemStack)Iterables.getFirst(BroomParts.REGISTRY.getItemsFromPart(broomPart), null);
                if (itemStack == null) continue;
                predefinedItems.put(id, itemStack);
            }
        }
        predefinedItems.put("evilcraft:potion_weakness", PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionType.func_185168_a((String)"weakness")));
        if (Configs.isEnabled(PoisonConfig.class)) {
            ItemStack poisonBucket = new ItemStack(Items.field_151133_ar);
            IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)poisonBucket);
            fluidHandler.fill(new FluidStack((Fluid)Poison.getInstance(), 1000), true);
            predefinedItems.put("evilcraft:bucketPoison", poisonBucket);
        }
        ItemStack potionPoison = new ItemStack((Item)Items.field_151068_bn);
        PotionUtils.func_185188_a((ItemStack)potionPoison, (PotionType)PotionType.func_185168_a((String)"poison"));
        predefinedItems.put("minecraft:potionPoison", potionPoison);
    }

    protected void registerCustomRecipes() {
        super.registerCustomRecipes();
        if (Configs.isEnabled(EntangledChaliceConfig.class) && Configs.isEnabled(DarkGemConfig.class) && Configs.isEnabled(CorruptedTearConfig.class)) {
            Item tear = CorruptedTearConfig._instance.getItemInstance();
            GameRegistry.addRecipe((IRecipe)new ObservableShapedRecipe(3, 3, new ItemStack[]{new ItemStack(Items.field_151043_k), new ItemStack(tear), new ItemStack(Items.field_151043_k), new ItemStack((Item)DarkGem.getInstance()), new ItemStack(Items.field_151043_k), new ItemStack((Item)DarkGem.getInstance()), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k)}, new ItemStack(Item.func_150898_a((Block)EntangledChalice.getInstance()), 2), new IRecipeOutputObserver(){

                public ItemStack getRecipeOutput(InventoryCrafting craftingGrid, ItemStack output) {
                    ItemStack newStack = output.func_77946_l();
                    EntangledChaliceItem item = (EntangledChaliceItem)Item.func_150898_a((Block)EntangledChalice.getInstance());
                    item.setNextTankID(newStack);
                    return newStack;
                }
            }));
            GameRegistry.addRecipe((IRecipe)new ObservableShapedRecipe(3, 3, new ItemStack[]{new ItemStack(Items.field_151043_k), new ItemStack(tear), new ItemStack(Items.field_151043_k), new ItemStack((Item)DarkGem.getInstance()), new ItemStack(Item.func_150898_a((Block)EntangledChalice.getInstance()), 1, Short.MAX_VALUE), new ItemStack((Item)DarkGem.getInstance()), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k)}, new ItemStack(Item.func_150898_a((Block)EntangledChalice.getInstance()), 2), new IRecipeOutputObserver(){

                public ItemStack getRecipeOutput(InventoryCrafting craftingGrid, ItemStack output) {
                    ItemStack newStack = output.func_77946_l();
                    EntangledChaliceItem item = (EntangledChaliceItem)Item.func_150898_a((Block)EntangledChalice.getInstance());
                    String tankID = item.getTankID(craftingGrid.func_70301_a(4));
                    item.setTankID(newStack, tankID);
                    return newStack;
                }
            }));
        }
        if (Configs.isEnabled(DarkTankConfig.class)) {
            for (int i = 1; i < 9; ++i) {
                ItemBlockFluidContainer tankItem = (ItemBlockFluidContainer)Item.func_150898_a((Block)DarkTank.getInstance());
                GameRegistry.addRecipe((IRecipe)new ItemBlockFluidContainerCombinationRecipe(i, tankItem));
            }
        }
        if (Configs.isEnabled(BloodExtractorConfig.class) && Configs.isEnabled(DarkTankConfig.class)) {
            for (int i = 1; i < 9; ++i) {
                GameRegistry.addRecipe((IRecipe)new BloodExtractorCombinationRecipe(i));
            }
        }
        if (Configs.isEnabled(BroomConfig.class)) {
            for (int i = 1; i < 9; ++i) {
                GameRegistry.addRecipe((IRecipe)new BroomPartCombinationRecipe(i));
            }
        }
        if (Configs.isEnabled(EnvironmentalAccumulatorConfig.class)) {
            ItemStack emptyContainer;
            ItemStack outputStack = null;
            String recipeName = null;
            if (Configs.isEnabled(WeatherContainerConfig.class)) {
                emptyContainer = WeatherContainer.createItemStack(WeatherContainer.WeatherContainerTypes.EMPTY, 1);
                WeatherType[] weatherInputs = new WeatherType[]{WeatherType.CLEAR, WeatherType.LIGHTNING, WeatherType.RAIN};
                WeatherType[] weatherOutputs = new WeatherType[]{WeatherType.RAIN, WeatherType.RAIN, WeatherType.CLEAR};
                for (int i = 0; i < weatherInputs.length; ++i) {
                    recipeName = "WeatherContainer" + weatherInputs[i].getClass().getSimpleName();
                    outputStack = WeatherContainer.createItemStack(WeatherContainer.WeatherContainerTypes.getWeatherContainerType(weatherInputs[i]), 1);
                    EnvironmentalAccumulator.getInstance().getRecipeRegistry().registerRecipe(recipeName, (IRecipeInput)new EnvironmentalAccumulatorRecipeComponent(emptyContainer, weatherInputs[i]), (IRecipeOutput)new EnvironmentalAccumulatorRecipeComponent(outputStack, weatherOutputs[i]), (IRecipeProperties)new EnvironmentalAccumulatorRecipeProperties());
                }
            }
            if (Configs.isEnabled(BiomeExtractConfig.class) && BiomeExtractConfig.hasRecipes) {
                emptyContainer = new ItemStack((Item)BiomeExtract.getInstance());
                ItemStack filledContainer = BiomeExtract.getInstance().createItemStack(null, 1);
                filledContainer.func_77964_b(Short.MAX_VALUE);
                EnvironmentalAccumulator.getInstance().getRecipeRegistry().registerRecipe(recipeName, (IRecipeInput)new EnvironmentalAccumulatorRecipeComponent(emptyContainer, WeatherType.ANY), (IRecipeOutput)new EnvironmentalAccumulatorRecipeComponent(filledContainer, WeatherType.ANY), (IRecipeProperties)new EnvironmentalAccumulatorRecipeProperties(1000, BiomeExtractConfig.envirAccCooldownTime, -1.0, null, new EnvironmentalAccumulatorRecipeProperties.IEAResultOverride(){

                    @Override
                    public ItemStack getResult(IBlockAccess world, BlockPos pos, ItemStack originalResult) {
                        World worldSafe = (World)world;
                        Biome biome = worldSafe.func_180494_b(pos);
                        if (BiomeExtractConfig._instance.isCraftingBlacklisted(Biome.func_185362_a((Biome)biome))) {
                            return BiomeExtract.getInstance().createItemStack(null, 1);
                        }
                        return BiomeExtract.getInstance().createItemStack(biome, 1);
                    }
                }));
            }
            if (Configs.isEnabled(DisplayStandConfig.class)) {
                this.getTaggedRecipes().put((Object)"craftingRecipe:displayStands", (Object)new Recipe((IRecipeInput)new ItemStacksRecipeComponent((List)Lists.newArrayList()), (IRecipeOutput)new ItemStackRecipeComponent(DisplayStand.getInstance().getTypedDisplayStandItem(Blocks.field_150344_f.func_176223_P())), (IRecipeProperties)new DummyPropertiesComponent()));
                GameRegistry.addRecipe((IRecipe)new DisplayStandRecipe(OreDictionary.getOres((String)"plankWood")));
            }
        }
    }
}

