/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.block.property.UnlistedProperty;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.evilcraft.block.EntangledChaliceItem;
import org.cyclops.evilcraft.core.block.IBlockRarityProvider;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.core.block.component.BlockTankComponent;
import org.cyclops.evilcraft.core.fluid.WorldSharedTank;
import org.cyclops.evilcraft.tileentity.TileEntangledChalice;

public class EntangledChalice
extends ConfigurableBlockContainer
implements IInformationProvider,
IBlockTank,
IBlockRarityProvider {
    private static EntangledChalice _instance = null;
    @BlockProperty
    public static final IUnlistedProperty<String> TANK_ID = new UnlistedProperty("tank_id", String.class);
    @BlockProperty
    public static final IUnlistedProperty<FluidStack> TANK_FLUID = new UnlistedProperty("tank_fluidstack", FluidStack.class);
    private BlockTankComponent<EntangledChalice> tankComponent = new BlockTankComponent<EntangledChalice>(this);

    public static EntangledChalice getInstance() {
        return _instance;
    }

    public EntangledChalice(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151573_f, TileEntangledChalice.class);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_149721_r(IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float motionX, float motionY, float motionZ) {
        return this.tankComponent.onBlockActivatedTank(world, blockPos, player, hand, heldItem, side, motionX, motionY, motionZ) || super.func_180639_a(world, blockPos, blockState, player, hand, heldItem, side, motionX, motionY, motionZ);
    }

    public String getInfo(ItemStack itemStack) {
        return this.tankComponent.getInfoTank(itemStack);
    }

    public void provideInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
    }

    @Override
    public String getTankNBTName() {
        return "entangledChalice";
    }

    @Override
    public int getTankCapacity(ItemStack itemStack) {
        return this.getMaxCapacity();
    }

    @Override
    public void setTankCapacity(ItemStack itemStack, int capacity) {
    }

    @Override
    public void setTankCapacity(NBTTagCompound tag, int capacity) {
    }

    public void writeAdditionalInfo(TileEntity tile, NBTTagCompound tag) {
        super.writeAdditionalInfo(tile, tag);
        this.tankComponent.writeAdditionalInfo(tile, tag);
    }

    @Override
    public int getMaxCapacity() {
        return 4000;
    }

    @Override
    public boolean isActivatable() {
        return true;
    }

    @Override
    public ItemStack toggleActivation(ItemStack itemStack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                ItemStack activated = itemStack.func_77946_l();
                activated.func_77964_b(1 - activated.func_77952_i());
                return activated;
            }
            return itemStack;
        }
        return itemStack;
    }

    @Override
    public boolean isActivated(ItemStack itemStack, World world, Entity entity) {
        return itemStack.func_77952_i() == 1;
    }

    public int getLightValue(IBlockState blockState, IBlockAccess world, BlockPos blockPos) {
        TileEntangledChalice tank;
        TileEntity tile = world.func_175625_s(blockPos);
        if (tile != null && tile instanceof TileEntangledChalice && (tank = (TileEntangledChalice)tile).getTank().getFluidType() != null) {
            return (int)Math.min(15.0, tank.getFillRatio() * (double)tank.getTank().getFluidType().getLuminosity());
        }
        return 0;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        ItemStack itemStack = new ItemStack(item);
        EntangledChaliceItem chaliceItem = (EntangledChaliceItem)Item.func_150898_a((Block)EntangledChalice.getInstance());
        chaliceItem.setTankID(itemStack, "creativeTank0");
        list.add(itemStack);
    }

    @Override
    public EnumRarity getRarity(ItemStack itemStack) {
        return EnumRarity.RARE;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        TileEntangledChalice tile = (TileEntangledChalice)((Object)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileEntangledChalice.class));
        if (tile != null) {
            FluidStack fluidStack = tile.getTank().getFluid();
            extendedBlockState = extendedBlockState.withProperty(TANK_ID, (Object)((WorldSharedTank)tile.getTank()).getTankID());
            if (fluidStack != null) {
                extendedBlockState = extendedBlockState.withProperty(TANK_FLUID, (Object)fluidStack);
            }
        }
        return extendedBlockState;
    }
}

