/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.core.fluid.FluidContainerItemWrapperWithSimulation;
import org.cyclops.evilcraft.core.fluid.WorldSharedTankCache;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.core.item.ItemBlockFluidContainer;

public class EntangledChaliceItem
extends ItemBlockFluidContainer {
    public EntangledChaliceItem(Block block) {
        super(block);
    }

    public String getTankID(ItemStack container) {
        String key = this.getBlockTank().getTankNBTName();
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b(key)) {
            container.func_77982_d(new NBTTagCompound());
            container.func_77978_p().func_74782_a(key, (NBTBase)new NBTTagCompound());
            container.func_77978_p().func_74775_l(key).func_74778_a("tankID", "invalid");
        }
        return container.func_77978_p().func_74775_l(key).func_74779_i("tankID");
    }

    public void setTankID(ItemStack container, String tankID) {
        String key = this.getBlockTank().getTankNBTName();
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        if (!container.func_77978_p().func_74764_b(key)) {
            container.func_77978_p().func_74782_a(key, (NBTBase)new NBTTagCompound());
        }
        container.func_77978_p().func_74775_l(key).func_74778_a("tankID", tankID);
    }

    public void setNextTankID(ItemStack container) {
        this.setTankID(container, Integer.toString(EvilCraft.globalCounters.getNext("EntangledChalice")));
    }

    @Override
    public FluidStack getFluid(ItemStack container) {
        return WorldSharedTankCache.getInstance().getTankContent(this.getTankID(container));
    }

    @Override
    protected void setFluid(ItemStack container, FluidStack fluidStack) {
        WorldSharedTankCache.getInstance().setTankContent(this.getTankID(container), fluidStack);
    }

    @Override
    protected void autofill(IFluidHandler source, ItemStack itemStack, World world, Entity entity) {
        if (entity instanceof EntityPlayer && !world.field_72995_K) {
            FluidStack tickFluid;
            EntityPlayer player = (EntityPlayer)entity;
            PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
            do {
                ItemStack filled;
                tickFluid = FluidHelpers.getFluid((IFluidHandler)source);
                ItemStack toFill = it.next();
                if (tickFluid == null || toFill == null || toFill.field_77994_a != 1 || (filled = ItemHelpers.tryFillContainerForPlayer(source, itemStack, toFill, tickFluid, player)) == null) continue;
                it.replace(filled);
            } while (tickFluid != null && tickFluid.amount > 0 && it.hasNext());
        }
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidContainerItemWrapperWithSimulation(this, stack);
    }
}

