/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.entity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerArrow;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.MobConfig;
import org.cyclops.evilcraft.entity.monster.VengeanceSpirit;

public class RenderVengeanceSpirit
extends Render<VengeanceSpirit> {
    private final RenderPlayerSpirit playerRenderer;
    private final Map<GameProfile, GameProfile> checkedProfiles = Maps.newHashMap();

    public RenderVengeanceSpirit(RenderManager renderManager, ExtendedConfig<MobConfig<VengeanceSpirit>> config) {
        super(renderManager);
        this.playerRenderer = new RenderPlayerSpirit(renderManager);
    }

    public void doRender(VengeanceSpirit spirit, double x, double y, double z, float yaw, float partialTickTime) {
        Render render;
        EntityLivingBase innerEntity = spirit.getInnerEntity();
        if (innerEntity != null && spirit.isVisible() && (render = (Render)this.field_76990_c.field_78729_o.get(innerEntity.getClass())) != null && !spirit.isSwarm()) {
            GlStateManager.func_179147_l();
            if (!spirit.isFrozen()) {
                GlStateManager.func_179112_b((int)768, (int)1);
            } else {
                GlStateManager.func_179112_b((int)768, (int)769);
            }
            float c = Math.min(1.0f - (float)spirit.getBuildupDuration() / 30.0f, 0.65f);
            GlStateManager.func_179124_c((float)c, (float)c, (float)c);
            try {
                if (spirit.func_70684_aJ()) {
                    GameProfile gameProfile = new GameProfile(spirit.getPlayerUUID(), spirit.getPlayerName());
                    ResourceLocation resourcelocation = DefaultPlayerSkin.func_177335_a();
                    Minecraft minecraft = Minecraft.func_71410_x();
                    if (!this.checkedProfiles.containsKey(gameProfile)) {
                        Property property = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), (Object)null);
                        if (property == null) {
                            GameProfile newGameProfile = Minecraft.func_71410_x().func_152347_ac().fillProfileProperties(gameProfile, true);
                            this.checkedProfiles.put(gameProfile, newGameProfile);
                        }
                    } else {
                        Map map = minecraft.func_152342_ad().func_152788_a(this.checkedProfiles.get(gameProfile));
                        if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                            resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                        }
                    }
                    this.playerRenderer.setPlayerTexture(resourcelocation);
                    this.playerRenderer.func_76986_a((EntityLiving)innerEntity, x, y, z, yaw, 0.0f);
                } else {
                    render.func_76986_a((Entity)innerEntity, x, y, z, yaw, 0.0f);
                }
            }
            catch (Exception e) {
                spirit.setSwarm(true);
                spirit.setPlayerId("");
            }
            GlStateManager.func_179084_k();
        }
    }

    protected ResourceLocation getEntityTexture(VengeanceSpirit entity) {
        return null;
    }

    public static class RenderPlayerSpirit
    extends RenderBiped {
        private ResourceLocation playerTexture;

        public RenderPlayerSpirit(RenderManager renderManager) {
            super(renderManager, (ModelBiped)new ModelPlayer(0.0f, false), 0.5f);
            ModelPlayer modelPlayer = (ModelPlayer)this.func_177087_b();
            this.func_177094_a((LayerRenderer)new LayerBipedArmor((RenderLivingBase)this));
            this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this));
            this.func_177094_a((LayerRenderer)new LayerArrow((RenderLivingBase)this));
            this.func_177094_a((LayerRenderer)new LayerCustomHead(modelPlayer.field_78116_c));
            modelPlayer.func_178719_a(true);
            Random rand = new Random();
            modelPlayer.field_178720_f.field_78806_j = rand.nextBoolean();
            modelPlayer.field_178730_v.field_78806_j = rand.nextBoolean();
            modelPlayer.field_178733_c.field_78806_j = rand.nextBoolean();
            modelPlayer.field_178731_d.field_78806_j = rand.nextBoolean();
            modelPlayer.field_178734_a.field_78806_j = rand.nextBoolean();
            modelPlayer.field_178732_b.field_78806_j = rand.nextBoolean();
        }

        protected ResourceLocation func_110775_a(EntityLiving entity) {
            return this.playerTexture;
        }

        public void setPlayerTexture(ResourceLocation playerTexture) {
            this.playerTexture = playerTexture;
        }
    }
}

