/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.cyclops.cyclopscore.client.model.DynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.evilcraft.block.DisplayStand;

public class ModelDisplayStand
extends DynamicItemAndBlockModel {
    private static final Map<EnumFacing, ModelRotation> ROTATIONS = ImmutableMap.builder().put((Object)EnumFacing.NORTH, (Object)ModelRotation.X270_Y0).put((Object)EnumFacing.SOUTH, (Object)ModelRotation.X90_Y0).put((Object)EnumFacing.WEST, (Object)ModelRotation.X90_Y90).put((Object)EnumFacing.EAST, (Object)ModelRotation.X270_Y90).put((Object)EnumFacing.UP, (Object)ModelRotation.X180_Y0).put((Object)EnumFacing.DOWN, (Object)ModelRotation.X0_Y0).build();
    private static final Map<String, IBakedModel> retexturedCache = Maps.newHashMap();
    private final IPerspectiveAwareModel untexturedBakedModel;
    private final IRetexturableModel retexturableModel;

    public ModelDisplayStand(IPerspectiveAwareModel untexturedBakedModel, IRetexturableModel retexturableModel) {
        super(true, false);
        this.untexturedBakedModel = untexturedBakedModel;
        this.retexturableModel = retexturableModel;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.untexturedBakedModel.func_177554_e();
    }

    protected IBakedModel handleDisplayStandType(ItemStack displayStandType, boolean axisX, EnumFacing facing) {
        if (displayStandType != null) {
            IBlockState blockState = BlockHelpers.getBlockStateFromItemStack((ItemStack)displayStandType);
            String textureName = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(blockState).func_94215_i();
            String cacheName = textureName + axisX + facing.toString();
            IBakedModel bakedRetexturedModel = retexturedCache.get(cacheName);
            if (bakedRetexturedModel == null) {
                IModel retexturedModel = this.retexturableModel.retexture(ImmutableMap.of((Object)"base", (Object)textureName));
                IModelState modelState = (IModelState)ROTATIONS.get(facing);
                bakedRetexturedModel = retexturedModel.bake(modelState, DefaultVertexFormats.field_176600_a, RenderHelpers.TEXTURE_GETTER);
                retexturedCache.put(cacheName, bakedRetexturedModel);
            }
            return bakedRetexturedModel;
        }
        return this.untexturedBakedModel;
    }

    public IBakedModel handleBlockState(IBlockState state, EnumFacing side, long rand) {
        return new IPerspectiveAwareModel.MapWrapper(this.handleDisplayStandType((ItemStack)((IExtendedBlockState)state).getValue(DisplayStand.TYPE), (Boolean)state.func_177229_b((IProperty)DisplayStand.AXIS_X), (EnumFacing)state.func_177229_b((IProperty)DisplayStand.FACING)), ModelHelpers.DEFAULT_PERSPECTIVE_TRANSFORMS);
    }

    public IBakedModel handleItemState(ItemStack itemStack, World world, EntityLivingBase entity) {
        return new IPerspectiveAwareModel.MapWrapper(this.handleDisplayStandType(DisplayStand.getInstance().getDisplayStandType(itemStack), true, EnumFacing.DOWN), ModelHelpers.DEFAULT_PERSPECTIVE_TRANSFORMS);
    }
}

