/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.block.component;

import javax.annotation.Nullable;
import net.minecraft.block.BlockContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.cyclopscore.tileentity.TankInventoryTileEntity;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.core.fluid.SimulatedFluidStack;

public class BlockTankComponent<T extends BlockContainer> {
    private T tank;

    public BlockTankComponent(T tank) {
        this.tank = tank;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean onBlockActivatedTank(World world, BlockPos blockPos, EntityPlayer player, EnumHand hand, ItemStack itemStack, EnumFacing side, float motionX, float motionY, float motionZ) {
        TankInventoryTileEntity tile = (TankInventoryTileEntity)world.func_175625_s(blockPos);
        if (tile != null && itemStack != null) {
            SimulatableTankWrapper tank = new SimulatableTankWrapper(tile.getTank());
            IFluidHandler itemFluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
            if (!player.func_70093_af() && !tank.isFull() && itemFluidHandler != null && FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)1000, (EntityPlayer)player, (boolean)false) != null) {
                ItemStack drainedItem = FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)1000, (EntityPlayer)player, (boolean)true);
                if (!player.field_71075_bZ.field_75098_d) {
                    if (drainedItem != null && drainedItem.field_77994_a == 0) {
                        drainedItem = null;
                    }
                    InventoryHelpers.tryReAddToStack((EntityPlayer)player, (ItemStack)itemStack, (ItemStack)drainedItem);
                }
                return true;
            }
            if (player.func_70093_af() && !tank.isEmpty() && FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)1000, (EntityPlayer)player, (boolean)false) != null) {
                ItemStack filledItem = FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)1000, (EntityPlayer)player, (boolean)true);
                if (!player.field_71075_bZ.field_75098_d) {
                    InventoryHelpers.tryReAddToStack((EntityPlayer)player, (ItemStack)itemStack, (ItemStack)filledItem);
                }
                return true;
            }
        }
        return false;
    }

    public String getInfoTank(ItemStack itemStack) {
        int amount = 0;
        FluidStack fluidStack = null;
        if (FluidUtil.getFluidHandler((ItemStack)itemStack) != null) {
            fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack);
        } else if (itemStack.func_77978_p() != null) {
            fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.func_77978_p().func_74775_l(((IBlockTank)this.tank).getTankNBTName()));
        }
        if (fluidStack != null) {
            amount = fluidStack.amount;
        }
        return DamageIndicatedItemComponent.getInfo((FluidStack)fluidStack, (int)amount, (int)((IBlockTank)this.tank).getTankCapacity(itemStack));
    }

    public void writeAdditionalInfo(TileEntity tile, NBTTagCompound tag) {
        if (tile instanceof TankInventoryTileEntity) {
            TankInventoryTileEntity tankTile = (TankInventoryTileEntity)tile;
            ((IBlockTank)this.tank).setTankCapacity(tag, tankTile.getTank().getCapacity());
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack() != null && event.getItemStack().hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && event.getWorld().func_180495_p(event.getPos()).func_177230_c() == this.tank) {
            event.setUseBlock(Event.Result.ALLOW);
        }
    }

    public static class SimulatableTankWrapper
    implements IFluidHandler {
        private final SingleUseTank tank;

        public SimulatableTankWrapper(SingleUseTank tank) {
            this.tank = tank;
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.tank.getTankProperties();
        }

        public int fill(FluidStack resource, boolean doFill) {
            return this.tank.fill(resource, doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            FluidStack drained = this.tank.drain(resource, doDrain);
            return doDrain ? drained : new SimulatedFluidStack(drained.getFluid(), drained.amount);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidStack drained = this.tank.drain(maxDrain, doDrain);
            return doDrain ? drained : new SimulatedFluidStack(drained.getFluid(), drained.amount);
        }

        public boolean isFull() {
            return this.tank.isFull();
        }

        public boolean isEmpty() {
            return this.tank.isEmpty();
        }
    }
}

