/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe;

import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.evilcraft.block.DarkTank;
import org.cyclops.evilcraft.core.item.ItemBlockFluidContainer;
import org.cyclops.evilcraft.fluid.Blood;
import org.cyclops.evilcraft.item.BloodExtractor;

public class BloodExtractorCombinationRecipe
implements IRecipe {
    private int size;

    public BloodExtractorCombinationRecipe(int size) {
        this.size = size;
    }

    public boolean func_77569_a(InventoryCrafting grid, World world) {
        return this.func_77572_b(grid) != null;
    }

    public int func_77570_a() {
        return this.size;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((Item)BloodExtractor.getInstance());
    }

    public ItemStack[] func_179532_b(InventoryCrafting inventory) {
        ItemStack[] aitemstack = new ItemStack[inventory.func_70302_i_()];
        for (int i = 0; i < aitemstack.length; ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            aitemstack[i] = ForgeHooks.getContainerItem((ItemStack)itemstack);
        }
        return aitemstack;
    }

    public ItemStack func_77572_b(InventoryCrafting grid) {
        ItemStack output = this.func_77571_b().func_77946_l();
        BloodExtractor bloodExtractor = BloodExtractor.getInstance();
        ItemBlockFluidContainer darkTank = (ItemBlockFluidContainer)Item.func_150898_a((Block)DarkTank.getInstance());
        Blood blood = Blood.getInstance();
        int totalCapacity = 0;
        int totalContent = 0;
        int extractors = 0;
        int tanks = 0;
        for (int j = 0; j < grid.func_70302_i_(); ++j) {
            FluidStack fluidStack;
            ItemStack element = grid.func_70301_a(j);
            if (element == null) continue;
            if (element.func_77973_b() == darkTank) {
                ++tanks;
                fluidStack = darkTank.getFluid(element);
                if (fluidStack != null) {
                    if (!((Object)((Object)blood)).equals(fluidStack.getFluid())) {
                        return null;
                    }
                    totalContent = Helpers.addSafe((int)totalContent, (int)fluidStack.amount);
                }
                totalCapacity = Helpers.addSafe((int)totalCapacity, (int)darkTank.getCapacity(element));
                continue;
            }
            if (element.func_77973_b() == bloodExtractor) {
                ++extractors;
                fluidStack = bloodExtractor.getFluid(element);
                if (fluidStack != null) {
                    if (!((Object)((Object)blood)).equals(fluidStack.getFluid())) {
                        return null;
                    }
                    totalContent = Helpers.addSafe((int)totalContent, (int)fluidStack.amount);
                }
                totalCapacity = Helpers.addSafe((int)totalCapacity, (int)bloodExtractor.getCapacity(element));
                continue;
            }
            return null;
        }
        if (extractors + tanks < 2 || extractors < 1 || totalCapacity > darkTank.getBlockTank().getMaxCapacity()) {
            return null;
        }
        bloodExtractor.setCapacity(output, totalCapacity);
        bloodExtractor.fill(output, new FluidStack((Fluid)blood, totalContent), true);
        return output;
    }
}

