/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.cyclops.cyclopscore.config.configurable.ConfigurableEnchantment;
import org.cyclops.cyclopscore.config.extendedconfig.EnchantmentConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.evilcraft.enchantment.EnchantmentVengeanceConfig;
import org.cyclops.evilcraft.item.VengeanceRing;
import org.cyclops.evilcraft.tileentity.tickaction.bloodchest.DamageableItemRepairAction;

public class EnchantmentVengeance
extends ConfigurableEnchantment {
    private static EnchantmentVengeance _instance = null;

    public static EnchantmentVengeance getInstance() {
        return _instance;
    }

    public EnchantmentVengeance(ExtendedConfig<EnchantmentConfig> eConfig) {
        super(eConfig, Enchantment.Rarity.COMMON, EnumEnchantmentType.ALL, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        DamageableItemRepairAction.BAD_ENCHANTS.add(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int func_77321_a(int level) {
        return 1 + (level - 1) * 8;
    }

    public int func_77317_b(int level) {
        return super.func_77321_a(level) + 50;
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemStack) {
        return false;
    }

    public boolean isAllowedOnBooks() {
        return true;
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack heldItem;
        int level;
        EntityPlayer player = event.getPlayer();
        if (player != null && !player.field_70170_p.field_72995_K && (level = EnchantmentVengeance.getEnchantLevel(heldItem = player.func_184586_b(player.func_184600_cs()))) > 0) {
            EnchantmentVengeance.apply(player.field_70170_p, level, (EntityLivingBase)player);
        }
    }

    @SubscribeEvent
    public void onAttack(LivingAttackEvent event) {
        EntityPlayer player;
        ItemStack heldItem;
        int level;
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof EntityPlayer && !entity.field_70170_p.field_72995_K && (level = EnchantmentVengeance.getEnchantLevel(heldItem = (player = (EntityPlayer)entity).func_184586_b(player.func_184600_cs()))) > 0) {
            EnchantmentVengeance.apply(player.field_70170_p, level, (EntityLivingBase)player);
        }
    }

    public static int getEnchantLevel(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        return EnchantmentHelper.func_77506_a((Enchantment)EnchantmentVengeance.getInstance(), (ItemStack)itemStack);
    }

    public static void apply(World world, int level, EntityLivingBase entity) {
        int chance;
        if (level > 0 && (chance = Math.max(1, EnchantmentVengeanceConfig.vengeanceChance / level)) > 0 && world.field_73012_v.nextInt(chance) == 0) {
            int area = EnchantmentVengeanceConfig.areaOfEffect * level;
            VengeanceRing.toggleVengeanceArea(world, (Entity)entity, area, true, true, true);
        }
    }
}

