/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.item;

import com.google.common.base.Optional;
import java.util.Random;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.particle.ParticleBlur;
import org.cyclops.cyclopscore.config.configurable.IConfigurable;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.core.algorithm.OrganicSpread;
import org.cyclops.evilcraft.core.entity.item.EntityThrowable;
import org.cyclops.evilcraft.entity.item.EntityWeatherContainer;
import org.cyclops.evilcraft.item.BiomeExtract;
import org.cyclops.evilcraft.item.BiomeExtractConfig;

public class EntityBiomeExtract
extends EntityThrowable
implements IConfigurable {
    private static final DataParameter<Optional<ItemStack>> ITEMSTACK_INDEX = EntityDataManager.func_187226_a(EntityWeatherContainer.class, (DataSerializer)DataSerializers.field_187196_f);

    public EntityBiomeExtract(World world) {
        super(world);
    }

    public EntityBiomeExtract(World world, EntityLivingBase entity, int damage) {
        this(world, entity, new ItemStack((Item)(Configs.isEnabled(BiomeExtractConfig.class) ? BiomeExtract.getInstance() : Items.field_151044_h), 1, damage));
    }

    public EntityBiomeExtract(World world, EntityLivingBase entity, ItemStack stack) {
        super(world, entity);
        this.setItemStack(stack);
    }

    protected void func_70184_a(final RayTraceResult movingobjectposition) {
        ItemStack itemStack = this.getItemStack();
        final Biome biome = BiomeExtract.getInstance().getBiome(itemStack);
        if (biome != null) {
            OrganicSpread spread = new OrganicSpread(this.field_70170_p, 2, 5, new OrganicSpread.IOrganicSpreadable(){

                @Override
                public boolean isDone(World world, BlockPos location) {
                    return world.func_180494_b(location) == biome;
                }

                @Override
                public void spreadTo(World world, BlockPos location) {
                    if (EntityBiomeExtract.this.field_70170_p.field_72995_K) {
                        EntityBiomeExtract.this.showChangedBiome(EntityBiomeExtract.this.field_70170_p, new BlockPos(location.func_177958_n(), movingobjectposition.func_178782_a().func_177956_o(), location.func_177952_p()), biome.func_180625_c(new BlockPos(0, 0, 0)));
                    }
                    WorldHelpers.setBiome((World)EntityBiomeExtract.this.field_70170_p, (BlockPos)location, (Biome)biome);
                }
            });
            BlockPos pos = movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK ? movingobjectposition.func_178782_a() : movingobjectposition.field_72308_g.func_180425_c();
            for (int i = 0; i < 50; ++i) {
                spread.spreadTick(pos);
            }
        }
        this.field_70170_p.func_175669_a(2002, this.func_180425_c(), 16428);
        this.func_70106_y();
    }

    @SideOnly(value=Side.CLIENT)
    private void showChangedBiome(World world, BlockPos pos, int color) {
        Triple c = Helpers.intToRGB((int)color);
        Random rand = world.field_73012_v;
        for (int j = 0; j < 2 + rand.nextInt(5); ++j) {
            float x = (float)pos.func_177958_n() + -0.5f + rand.nextFloat();
            float y = (float)pos.func_177956_o() + -0.5f + rand.nextFloat();
            float z = (float)pos.func_177952_p() + -0.5f + rand.nextFloat();
            float scale = 0.2f - rand.nextFloat() * 0.2f;
            float red = ((Float)c.getLeft()).floatValue() + rand.nextFloat() * 0.1f;
            float green = ((Float)c.getMiddle()).floatValue() + rand.nextFloat() * 0.1f;
            float blue = ((Float)c.getRight()).floatValue() + rand.nextFloat() * 0.1f;
            float ageMultiplier = 10 + rand.nextInt(15);
            double motionX = -0.1f + rand.nextFloat() * 0.2f;
            double motionY = 0.1f + rand.nextFloat() * 0.2f;
            double motionZ = -0.1f + rand.nextFloat() * 0.2f;
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)new ParticleBlur(world, (double)x, (double)y, (double)z, scale, motionX, motionY, motionZ, red, green, blue, ageMultiplier));
        }
    }

    protected float func_70185_h() {
        return 0.1f;
    }

    @Override
    public ItemStack getItemStack() {
        Optional optional = (Optional)this.field_70180_af.func_187225_a(ITEMSTACK_INDEX);
        return optional.isPresent() ? (ItemStack)optional.get() : null;
    }

    private void setItemStack(ItemStack stack) {
        this.field_70180_af.func_187227_b(ITEMSTACK_INDEX, (Object)Optional.of((Object)stack));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ITEMSTACK_INDEX, (Object)Optional.of((Object)BiomeExtract.getInstance().createItemStack(null, 1)));
    }

    public ExtendedConfig<?> getConfig() {
        return null;
    }
}

