/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.MobConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.modcompat.IMCHandler;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.client.render.entity.RenderVengeanceSpirit;
import org.cyclops.evilcraft.entity.monster.VengeanceSpirit;

public class VengeanceSpiritConfig
extends MobConfig<VengeanceSpirit> {
    public static VengeanceSpiritConfig _instance;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MOB, comment="Should the Vengeance Spirit be enabled?", requiresMcRestart=true)
    public static boolean isEnabled;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MOB, comment="The maximum amount of vengeance spirits naturally spawnable in the spawnLimitArea.")
    public static int spawnLimit;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MOB, comment="The area in which the spawn limit will be checked on each spawn attempt.")
    public static int spawnLimitArea;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MOB, comment="The blacklisted entity spirits, by entity name.", changedCallback=VengeanceSpirit.SpiritBlacklistChanged.class)
    public static String[] entityBlacklist;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MOB, comment="The 1/X chance that an actual spirit will spawn when doing actions like mining with the Vengeance Pickaxe.")
    public static int nonDegradedSpawnChance;

    public VengeanceSpiritConfig() {
        super((ModBase)EvilCraft._instance, true, "vengeanceSpirit", null, VengeanceSpirit.class);
    }

    public boolean isEnabled() {
        return isEnabled;
    }

    public int getBackgroundEggColor() {
        return Helpers.RGBToInt((int)64, (int)16, (int)93);
    }

    public int getForegroundEggColor() {
        return Helpers.RGBToInt((int)134, (int)60, (int)169);
    }

    @SideOnly(value=Side.CLIENT)
    public Render<VengeanceSpirit> getRender(RenderManager renderManager) {
        return new RenderVengeanceSpirit(renderManager, (ExtendedConfig<MobConfig<VengeanceSpirit>>)this);
    }

    public void onInit(IInitListener.Step step) {
        super.onInit(step);
        if (step == IInitListener.Step.INIT) {
            EvilCraft._instance.getImcHandler().registerAction("blacklistVengeanceSpirit", new IMCHandler.IIMCAction(){

                public boolean handle(FMLInterModComms.IMCMessage message) {
                    if (!message.isStringMessage()) {
                        return false;
                    }
                    try {
                        Class<?> clazz = Class.forName(message.getStringValue());
                        VengeanceSpirit.addToBlacklistIMC(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        EvilCraft.clog("IMC blacklist vengeance spirit did not provide an existing class.", Level.ERROR);
                        return false;
                    }
                    catch (ClassCastException e) {
                        EvilCraft.clog("IMC blacklist vengeance spirit did not provide a class of type EntityLivingBase.", Level.ERROR);
                        return false;
                    }
                    return true;
                }
            });
        }
    }

    static {
        isEnabled = true;
        spawnLimit = 5;
        spawnLimitArea = 5;
        entityBlacklist = new String[]{"evilcraft.werewolf", "intangible.soul"};
        nonDegradedSpawnChance = 5;
    }
}

