/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.infobook;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoBook;
import org.cyclops.cyclopscore.infobook.InfoBookParser;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.component.ItemStackRecipeComponent;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.BroomModifiers;
import org.cyclops.evilcraft.block.BloodInfuser;
import org.cyclops.evilcraft.block.BloodInfuserConfig;
import org.cyclops.evilcraft.block.EnvironmentalAccumulator;
import org.cyclops.evilcraft.block.EnvironmentalAccumulatorConfig;
import org.cyclops.evilcraft.core.recipe.custom.DurationXpRecipeProperties;
import org.cyclops.evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeComponent;
import org.cyclops.evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeProperties;
import org.cyclops.evilcraft.core.recipe.custom.ItemFluidStackAndTierRecipeComponent;
import org.cyclops.evilcraft.core.weather.WeatherType;
import org.cyclops.evilcraft.infobook.pageelement.BloodInfuserRecipeAppendix;
import org.cyclops.evilcraft.infobook.pageelement.BroomModifierRecipeAppendix;
import org.cyclops.evilcraft.infobook.pageelement.EnvironmentalAccumulatorRecipeAppendix;
import org.cyclops.evilcraft.item.BroomConfig;
import org.w3c.dom.Element;

public class OriginsOfDarknessBook
extends InfoBook {
    private static OriginsOfDarknessBook _instance = null;

    private OriginsOfDarknessBook() {
        super((ModBase)EvilCraft._instance, 2);
    }

    public static OriginsOfDarknessBook getInstance() {
        if (_instance == null) {
            _instance = new OriginsOfDarknessBook();
        }
        return _instance;
    }

    static {
        if (Configs.isEnabled(BloodInfuserConfig.class)) {
            InfoBookParser.registerFactory((String)"evilcraft:bloodInfuserRecipe", (InfoBookParser.IAppendixFactory)new InfoBookParser.IAppendixFactory(){

                public SectionAppendix create(IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                    ItemStack itemStack = InfoBookParser.createStack((Element)node, (RecipeHandler)infoBook.getMod().getRecipeHandler());
                    List recipes = BloodInfuser.getInstance().getRecipeRegistry().findRecipesByOutput((IRecipeOutput)new ItemStackRecipeComponent(itemStack));
                    int index = InfoBookParser.getIndex((Element)node);
                    if (index >= recipes.size()) {
                        throw new InfoBookParser.InvalidAppendixException("Could not find Blood Infuser recipe for " + itemStack.func_77973_b().func_77658_a() + "with index " + index);
                    }
                    return new BloodInfuserRecipeAppendix(infoBook, (IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties>)((IRecipe)recipes.get(index)));
                }
            });
        } else {
            InfoBookParser.registerIgnoredFactory((String)"evilcraft:bloodInfuserRecipe");
        }
        if (Configs.isEnabled(EnvironmentalAccumulatorConfig.class)) {
            InfoBookParser.registerFactory((String)"evilcraft:envirAccRecipe", (InfoBookParser.IAppendixFactory)new InfoBookParser.IAppendixFactory(){

                public SectionAppendix create(IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                    ItemStack itemStack = InfoBookParser.createStack((Element)node, (RecipeHandler)infoBook.getMod().getRecipeHandler());
                    List recipes = EnvironmentalAccumulator.getInstance().getRecipeRegistry().findRecipesByOutput((IRecipeOutput)new EnvironmentalAccumulatorRecipeComponent(itemStack, WeatherType.ANY));
                    int index = InfoBookParser.getIndex((Element)node);
                    if (index >= recipes.size()) {
                        throw new InfoBookParser.InvalidAppendixException("Could not find Environmental Accumulator recipe for " + itemStack.func_77973_b().func_77658_a() + "with index " + index);
                    }
                    return new EnvironmentalAccumulatorRecipeAppendix(infoBook, (IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties>)((IRecipe)recipes.get(index)));
                }
            });
        } else {
            InfoBookParser.registerIgnoredFactory((String)"evilcraft:envirAccRecipe");
        }
        if (Configs.isEnabled(BloodInfuserConfig.class)) {
            InfoBookParser.registerFactory((String)"evilcraft:bloodInfuserRecipe", (InfoBookParser.IAppendixItemFactory)new InfoBookParser.IAppendixItemFactory<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties>(){

                public SectionAppendix create(IInfoBook infoBook, IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe) throws InfoBookParser.InvalidAppendixException {
                    return new BloodInfuserRecipeAppendix(infoBook, recipe);
                }
            });
        } else {
            InfoBookParser.registerIgnoredFactory((String)"evilcraft:bloodInfuserRecipe");
        }
        if (Configs.isEnabled(EnvironmentalAccumulatorConfig.class)) {
            InfoBookParser.registerFactory((String)"evilcraft:envirAccRecipe", (InfoBookParser.IAppendixItemFactory)new InfoBookParser.IAppendixItemFactory<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties>(){

                public SectionAppendix create(IInfoBook infoBook, IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> recipe) throws InfoBookParser.InvalidAppendixException {
                    return new EnvironmentalAccumulatorRecipeAppendix(infoBook, recipe);
                }
            });
        } else {
            InfoBookParser.registerIgnoredFactory((String)"evilcraft:envirAccRecipe");
        }
        if (Configs.isEnabled(BroomConfig.class)) {
            InfoBookParser.registerFactory((String)"evilcraft:broomModifier", (InfoBookParser.IAppendixFactory)new InfoBookParser.IAppendixFactory(){

                public SectionAppendix create(IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                    String id = node.getTextContent();
                    HashMap values = Maps.newHashMap();
                    BroomModifier finalModifier = null;
                    for (BroomModifier modifier : BroomModifiers.REGISTRY.getModifiers()) {
                        if (!modifier.getId().toString().equals(id)) continue;
                        finalModifier = modifier;
                        values.putAll(BroomModifiers.REGISTRY.getItemsFromModifier(modifier));
                    }
                    if (finalModifier == null) {
                        throw new InfoBookParser.InvalidAppendixException("Could not find the broom modifier " + id);
                    }
                    if (values.isEmpty()) {
                        throw new InfoBookParser.InvalidAppendixException("The broom modifier " + id + " has no valid items");
                    }
                    return new BroomModifierRecipeAppendix(infoBook, finalModifier, values);
                }
            });
        } else {
            InfoBookParser.registerIgnoredFactory((String)"evilcraft:broomModifier");
        }
    }
}

