/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.inventory.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.inventory.container.ItemInventoryContainer;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.core.inventory.NBTCraftingGrid;
import org.cyclops.evilcraft.item.ExaltedCrafter;
import org.cyclops.evilcraft.item.ExaltedCrafterConfig;
import org.cyclops.evilcraft.network.packet.ExaltedCrafterButtonPacket;

@ChestContainer
public class ContainerExaltedCrafter
extends ItemInventoryContainer<ExaltedCrafter> {
    private static final int GRID_OFFSET_X = 30;
    private static final int GRID_OFFSET_Y = 17;
    private static final int GRID_ROWS = 3;
    private static final int GRID_COLUMNS = 3;
    private static final int CHEST_INVENTORY_OFFSET_X = 8;
    private static final int CHEST_INVENTORY_OFFSET_Y = 84;
    private static final int CHEST_INVENTORY_ROWS = 3;
    private static final int CHEST_INVENTORY_COLUMNS = 9;
    private static final int INVENTORY_OFFSET_X = 8;
    private static final int INVENTORY_OFFSET_Y = 143;
    private World world;
    private EntityPlayer player;
    private NBTCraftingGrid craftingGrid;
    private InventoryCraftResult result;
    private boolean initialized = false;
    private static final Map<Integer, IButtonAction> ACTIONS = Maps.newHashMap();

    public ContainerExaltedCrafter(EntityPlayer player, int itemIndex) {
        super(player.field_71071_by, (Item)ExaltedCrafter.getInstance(), itemIndex);
        this.world = player.field_70170_p;
        this.player = player;
        this.result = new InventoryCraftResult();
        this.craftingGrid = new NBTCraftingGrid(player, itemIndex, (Container)this);
        this.addCraftingGrid(player, this.craftingGrid);
        this.addInventory(((ExaltedCrafter)this.getItem()).getSupplementaryInventory(player, InventoryHelpers.getItemFromIndex((EntityPlayer)player, (int)itemIndex), itemIndex), 0, 8, 84, 3, 9);
        this.addPlayerInventory(player.field_71071_by, 8, 143);
        this.initialized = true;
        this.func_75130_a((IInventory)this.craftingGrid);
    }

    public void sendPressButton(int buttonId) {
        if (ACTIONS.containsKey(buttonId)) {
            this.executePressButton(buttonId);
            EvilCraft._instance.getPacketHandler().sendToServer((PacketBase)new ExaltedCrafterButtonPacket(buttonId));
        }
    }

    public void executePressButton(int buttonId) {
        if (ACTIONS.containsKey(buttonId)) {
            ACTIONS.get(buttonId).execute(this);
        }
    }

    public void clearGrid() {
        for (int i = 0; i < this.craftingGrid.func_70302_i_(); ++i) {
            this.func_82846_b(this.player, i);
        }
    }

    public void balanceGrid() {
        ArrayList bins = Lists.newArrayListWithExpectedSize((int)this.craftingGrid.func_70302_i_());
        for (int slot = 0; slot < this.craftingGrid.func_70302_i_(); ++slot) {
            ItemStack itemStack = this.craftingGrid.func_70301_a(slot);
            if (itemStack == null) continue;
            int amount = itemStack.field_77994_a;
            itemStack = itemStack.func_77946_l();
            itemStack.field_77994_a = 1;
            boolean addedToBin = false;
            for (int bin = 0; bin < bins.size() && !addedToBin; ++bin) {
                Pair pair = (Pair)bins.get(bin);
                ItemStack original = ((ItemStack)pair.getLeft()).func_77946_l();
                original.field_77994_a = 1;
                if (!ItemStack.func_77989_b((ItemStack)original, (ItemStack)itemStack)) continue;
                ((ItemStack)pair.getLeft()).field_77994_a += amount;
                ((List)pair.getRight()).add(new MutablePair((Object)slot, (Object)0));
                addedToBin = true;
            }
            if (addedToBin) continue;
            itemStack.field_77994_a = amount;
            bins.add(new MutablePair((Object)itemStack, (Object)Lists.newArrayList((Object[])new Pair[]{new MutablePair((Object)slot, (Object)0)})));
        }
        for (Pair pair : bins) {
            int division = ((ItemStack)pair.getLeft()).field_77994_a / ((List)pair.getRight()).size();
            int modulus = ((ItemStack)pair.getLeft()).field_77994_a % ((List)pair.getRight()).size();
            for (Pair slot : (List)pair.getRight()) {
                slot.setValue((Object)(division + Math.max(0, Math.min(1, modulus--))));
            }
        }
        for (Pair pair : bins) {
            for (Pair slot : (List)pair.getRight()) {
                ItemStack itemStack = ((ItemStack)pair.getKey()).func_77946_l();
                itemStack.field_77994_a = (Integer)slot.getRight();
                this.craftingGrid.func_70299_a((Integer)slot.getKey(), itemStack);
            }
        }
    }

    public boolean isReturnToInnerInventory() {
        ItemStack itemStack = this.getItemStack(this.player);
        return itemStack != null && ExaltedCrafter.getInstance().isReturnToInner(itemStack);
    }

    protected void setReturnToInnerInventory(boolean returnToInner) {
        ItemStack itemStack = this.getItemStack(this.player);
        if (itemStack != null) {
            ExaltedCrafter.getInstance().setReturnToInner(itemStack, returnToInner);
        }
    }

    protected int getSlotStart(int originSlot, int slotStart, boolean reverse) {
        if (!reverse && !ExaltedCrafterConfig.shiftCraftingGrid) {
            return 10;
        }
        if (reverse && originSlot < 10) {
            if (this.isReturnToInnerInventory()) {
                return 10;
            }
            return slotStart;
        }
        return super.getSlotStart(originSlot, slotStart, reverse);
    }

    protected int getSlotRange(int originSlot, int slotRange, boolean reverse) {
        if (this.isReturnToInnerInventory() && reverse && originSlot < 10) {
            return this.getSizeInventory();
        }
        return slotRange;
    }

    protected void addCraftingGrid(EntityPlayer player, NBTCraftingGrid grid) {
        this.addInventory((IInventory)grid, 0, 30, 17, 3, 3);
        this.func_75146_a((Slot)new SlotCrafting(player, (InventoryCrafting)grid, (IInventory)this.result, 0, 124, 35));
    }

    protected int getSizeInventory() {
        return 37;
    }

    public void func_75130_a(IInventory inventory) {
        if (this.initialized) {
            this.result.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)this.craftingGrid, this.world));
            this.craftingGrid.save();
        }
    }

    @ContainerSectionCallback
    public Map<ContainerSection, List<Slot>> getContainerSelection() {
        int i;
        HashMap selection = Maps.newHashMap();
        LinkedList craftingInSlots = Lists.newLinkedList();
        LinkedList craftingOutSlots = Lists.newLinkedList();
        LinkedList craftingChest = Lists.newLinkedList();
        ArrayList playerInventory = Lists.newArrayList();
        for (i = 0; i < 9; ++i) {
            craftingInSlots.add(this.func_75139_a(i));
        }
        for (i = 10; i < 37; ++i) {
            craftingChest.add(this.func_75139_a(i));
        }
        for (i = 37; i < 73; ++i) {
            playerInventory.add(this.func_75139_a(i));
        }
        selection.put(ContainerSection.CRAFTING_IN_PERSISTENT, craftingInSlots);
        selection.put(ContainerSection.CRAFTING_OUT, craftingOutSlots);
        selection.put(ContainerSection.CHEST, craftingChest);
        selection.put(ContainerSection.INVENTORY, playerInventory);
        return selection;
    }

    static {
        ACTIONS.put(1, new IButtonAction(){

            @Override
            public void execute(ContainerExaltedCrafter container) {
                container.clearGrid();
            }
        });
        ACTIONS.put(2, new IButtonAction(){

            @Override
            public void execute(ContainerExaltedCrafter container) {
                container.balanceGrid();
            }
        });
        ACTIONS.put(3, new IButtonAction(){

            @Override
            public void execute(ContainerExaltedCrafter container) {
                container.setReturnToInnerInventory(!container.isReturnToInnerInventory());
            }
        });
    }

    private static interface IButtonAction {
        public void execute(ContainerExaltedCrafter var1);
    }
}

