/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.ConfigurableItem;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.EvilCraftSoundEvents;

public abstract class AbstractFocus
extends ConfigurableItem {
    private static final int TICK_MODULUS = 3;

    public AbstractFocus(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig);
        this.func_77627_a(true);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return itemstack != null && itemstack.func_77973_b() instanceof AbstractFocus ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    private int getItemInUseDuration(EntityLivingBase player) {
        return Math.max(0, player.func_184612_cw() - player.func_184605_cv());
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        if (this.getItemInUseDuration((EntityLivingBase)player) > 0) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
        }
        player.func_184598_c(hand);
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack itemStack) {
        return Integer.MAX_VALUE;
    }

    public void func_77615_a(ItemStack itemStack, World world, EntityLivingBase player, int duration) {
        if (player.field_70170_p.field_72995_K && this.getItemInUseDuration(player) > 6) {
            player.func_184185_a(EvilCraftSoundEvents.effect_vengeancebeam_stop, 0.6f + player.field_70170_p.field_73012_v.nextFloat() * 0.2f, 1.0f);
        }
    }

    protected abstract EntityThrowable newBeamEntity(EntityLivingBase var1);

    public void onUsingTick(ItemStack itemStack, EntityLivingBase player, int remaining) {
        int duration = this.func_77626_a(itemStack) - remaining;
        if (duration > 6) {
            if (WorldHelpers.efficientTick((World)player.field_70170_p, (int)3, (int[])new int[]{player.func_145782_y()})) {
                EntityThrowable beam = this.newBeamEntity(player);
                if (!player.field_70170_p.field_72995_K) {
                    beam.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 0.5f, 1.0f);
                    player.field_70170_p.func_72838_d((Entity)beam);
                }
            }
        } else if (duration == 3 && player.field_70170_p.field_72995_K) {
            player.func_184185_a(EvilCraftSoundEvents.effect_vengeancebeam_start, 0.6f + player.field_70170_p.field_73012_v.nextFloat() * 0.2f, 1.0f);
        }
    }
}

