/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.IChangedCallback;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.item.BiomeExtract;

public class BiomeExtractConfig
extends ItemConfig {
    public static BiomeExtractConfig _instance;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="If creative versions for all variants should be added to the creative tab.", requiresMcRestart=true)
    public static boolean creativeTabVariants;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="If this should have recipes inside the Environmental Accumulator.", requiresMcRestart=true)
    public static boolean hasRecipes;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="The cooldown time int the Environmental Accumulator recipe.", requiresMcRestart=true)
    public static int envirAccCooldownTime;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="A list of biome names for which no Biome Extracts may be created.", changedCallback=CraftingBlacklistChanged.class)
    public static String[] craftingBlacklist;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="A list of biome names for which no Biome Extracts may be used.", changedCallback=UsageBlacklistChanged.class)
    public static String[] usageBlacklist;
    private Set<ResourceLocation> craftingBlacklistIds = Sets.newHashSet();
    private Set<ResourceLocation> usageBlacklistIds = Sets.newHashSet();

    public BiomeExtractConfig() {
        super((ModBase)EvilCraft._instance, true, "biomeExtract", null, BiomeExtract.class);
    }

    public String getModelName(ItemStack itemStack) {
        if (((BiomeExtract)this.getItemInstance()).isEmpty(itemStack)) {
            return super.getModelName(itemStack) + "_empty";
        }
        return super.getModelName(itemStack);
    }

    public void setBlacklist(String[] config, Set<ResourceLocation> blacklistNames) {
        blacklistNames.clear();
        for (String line : config) {
            try {
                ResourceLocation biomeKey = new ResourceLocation(line);
                if (!Biome.field_185377_q.func_148741_d((Object)biomeKey)) {
                    EvilCraft.clog("Invalid line '" + line + "' found for " + "a Biome Extract blacklist config: " + line + " does not refer to an existing biome; skipping.");
                    continue;
                }
                blacklistNames.add(biomeKey);
            }
            catch (NumberFormatException e) {
                EvilCraft.clog("Invalid line '" + line + "' found for " + "a Biome Extract blacklist config: " + line + " is not a number; skipping.");
            }
        }
    }

    public boolean isCraftingBlacklisted(int biomeId) {
        return this.craftingBlacklistIds.contains(biomeId);
    }

    public boolean isUsageBlacklisted(Biome biome) {
        return this.usageBlacklistIds.contains(((ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biome)).toString());
    }

    static {
        creativeTabVariants = true;
        hasRecipes = true;
        envirAccCooldownTime = 500;
        craftingBlacklist = new String[]{String.valueOf(Biome.field_185377_q.func_177774_c((Object)Biomes.field_76779_k))};
        usageBlacklist = new String[]{String.valueOf(Biome.field_185377_q.func_177774_c((Object)Biomes.field_76779_k))};
    }

    public static class UsageBlacklistChanged
    implements IChangedCallback {
        private static boolean calledOnce = false;

        public void onChanged(Object value) {
            if (calledOnce) {
                _instance.setBlacklist((String[])value, _instance.usageBlacklistIds);
            }
            calledOnce = true;
        }

        public void onRegisteredPostInit(Object value) {
            this.onChanged(value);
        }
    }

    public static class CraftingBlacklistChanged
    implements IChangedCallback {
        private static boolean calledOnce = false;

        public void onChanged(Object value) {
            if (calledOnce) {
                _instance.setBlacklist((String[])value, _instance.craftingBlacklistIds);
            }
            calledOnce = true;
        }

        public void onRegisteredPostInit(Object value) {
            this.onChanged(value);
        }
    }
}

