/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.modcompat.bloodmagic;

import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.modcompat.bloodmagic.BoundBloodDropConfig;
import org.cyclops.evilcraft.modcompat.bloodmagic.RequestSoulNetworkUpdatesPacket;
import org.cyclops.evilcraft.modcompat.bloodmagic.UpdateSoulNetworkCachePacket;

public class ClientSoulNetworkHandler {
    private static ClientSoulNetworkHandler _instance = null;
    private Map<String, Integer> PLAYER_CACHE = Maps.newHashMap();
    private Set<String> UPDATE_PLAYERS = Sets.newHashSet();

    private ClientSoulNetworkHandler() {
    }

    public static void reset() {
        ClientSoulNetworkHandler.getInstance().PLAYER_CACHE = Maps.newHashMap();
    }

    public static ClientSoulNetworkHandler getInstance() {
        if (_instance == null) {
            _instance = new ClientSoulNetworkHandler();
        }
        return _instance;
    }

    public int getCurrentEssence(String uuid) {
        if (MinecraftHelpers.isClientSide()) {
            Integer ret = this.PLAYER_CACHE.get(uuid);
            if (ret == null) {
                EvilCraft._instance.getPacketHandler().sendToServer((PacketBase)new RequestSoulNetworkUpdatesPacket(uuid));
                return 0;
            }
            return ret;
        }
        return NetworkHelper.getSoulNetwork((String)uuid).getCurrentEssence();
    }

    public void setCurrentEssence(String uuid, int currentEssence) {
        this.PLAYER_CACHE.put(uuid, currentEssence);
    }

    public void addUpdatePlayer(String uuid) {
        this.UPDATE_PLAYERS.add(uuid);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && WorldHelpers.efficientTick((World)FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0], (int)BoundBloodDropConfig.maxUpdateTicks, (int[])new int[0])) {
            HashMap toSend = Maps.newHashMap();
            for (String uuid : this.UPDATE_PLAYERS) {
                int essence = NetworkHelper.getSoulNetwork((String)uuid).getCurrentEssence();
                Integer found = this.PLAYER_CACHE.get(uuid);
                if (found != null && essence == found) continue;
                toSend.put(uuid, essence);
                this.setCurrentEssence(uuid, essence);
            }
            this.sendUpdates(toSend);
        }
    }

    private void sendUpdates(Map<String, Integer> toSend) {
        EvilCraft._instance.getPacketHandler().sendToAll((PacketBase)new UpdateSoulNetworkCachePacket(toSend));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K) {
            ClientSoulNetworkHandler.reset();
        }
    }
}

