/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.modcompat.jei.sanguinaryenvironmentalaccumulator;

import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.evilcraft.block.SanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.modcompat.jei.environmentalaccumulator.CommonEnvironmentalAccumulatorRecipeCategory;
import org.cyclops.evilcraft.modcompat.jei.environmentalaccumulator.EnvironmentalAccumulatorRecipeJEIBase;
import org.cyclops.evilcraft.tileentity.TileSanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.tileentity.tickaction.sanguinaryenvironmentalaccumulator.AccumulateItemTickAction;

public class SanguinaryEnvironmentalAccumulatorRecipeCategory
extends CommonEnvironmentalAccumulatorRecipeCategory {
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int FLUID_SLOT = 2;
    private final IDrawable background;
    private final IDrawableAnimated arrow;
    private final IDrawable tankOverlay;

    public SanguinaryEnvironmentalAccumulatorRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, (Pair<Integer, Integer>)Pair.of((Object)42, (Object)8), (Pair<Integer, Integer>)Pair.of((Object)96, (Object)8));
        ResourceLocation resourceLocation = new ResourceLocation("evilcraft:" + SanguinaryEnvironmentalAccumulator.getInstance().getGuiTexture("_jei"));
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 130, 70);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(resourceLocation, 146, 0, 24, 16);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tankOverlay = guiHelper.createDrawable(resourceLocation, 130, 0, 16, 58);
    }

    @Nonnull
    public String getUid() {
        return "evilcraft:sanguinaryEnvironmentalAccumulator";
    }

    @Nonnull
    public String getTitle() {
        return L10NHelpers.localize((String)(SanguinaryEnvironmentalAccumulator.getInstance().func_149739_a() + ".name"));
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public void drawExtras(Minecraft minecraft) {
        super.drawExtras(minecraft);
        this.arrow.draw(minecraft, 65, 28);
    }

    @Override
    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        super.setRecipe(recipeLayout, recipeWrapper);
        recipeLayout.getItemStacks().init(0, true, 41, 27);
        recipeLayout.getItemStacks().init(1, false, 95, 27);
        if (recipeWrapper instanceof EnvironmentalAccumulatorRecipeJEIBase) {
            EnvironmentalAccumulatorRecipeJEIBase recipe = (EnvironmentalAccumulatorRecipeJEIBase)recipeWrapper;
            recipeLayout.getItemStacks().set(0, recipe.getInput());
            recipeLayout.getItemStacks().set(1, recipe.getOutput());
            FluidStack fluidStack = new FluidStack(TileSanguinaryEnvironmentalAccumulator.ACCEPTED_FLUID, AccumulateItemTickAction.getUsage(recipe.getProperties()));
            recipeLayout.getFluidStacks().init(2, true, 6, 6, 16, 58, fluidStack == null ? 0 : fluidStack.amount, true, this.tankOverlay);
            recipeLayout.getFluidStacks().set(2, fluidStack);
        }
    }
}

