/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.modcompat.thermalexpansion;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.oredict.OreDictionary;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.modcompat.IModCompat;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.component.ItemStackRecipeComponent;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.block.BloodInfuser;
import org.cyclops.evilcraft.block.BloodInfuserConfig;
import org.cyclops.evilcraft.block.DarkOre;
import org.cyclops.evilcraft.block.DarkOreConfig;
import org.cyclops.evilcraft.block.UndeadLogConfig;
import org.cyclops.evilcraft.block.UndeadPlankConfig;
import org.cyclops.evilcraft.core.recipe.custom.DurationXpRecipeProperties;
import org.cyclops.evilcraft.core.recipe.custom.ItemFluidStackAndTierRecipeComponent;
import org.cyclops.evilcraft.fluid.Blood;
import org.cyclops.evilcraft.fluid.Poison;
import org.cyclops.evilcraft.item.BloodWaxedCoalConfig;
import org.cyclops.evilcraft.item.DarkGem;
import org.cyclops.evilcraft.item.DarkGemConfig;
import org.cyclops.evilcraft.item.DarkGemCrushedConfig;
import org.cyclops.evilcraft.item.EnderTearConfig;
import org.cyclops.evilcraft.item.HardenedBloodShardConfig;

public class ThermalExpansionModCompat
implements IModCompat {
    public String getModID() {
        return "thermalexpansion";
    }

    public void onInit(IInitListener.Step step) {
        if (step == IInitListener.Step.INIT) {
            this.registerThermalExpansionRecipes();
        }
    }

    private void registerThermalExpansionRecipes() {
        Fluid ender;
        String TE = this.getModID();
        EvilCraft.clog("Registering " + TE + " recipes");
        if (Configs.isEnabled(UndeadLogConfig.class) && Configs.isEnabled(UndeadPlankConfig.class)) {
            NBTTagCompound sawmillUndeadWood = new NBTTagCompound();
            sawmillUndeadWood.func_74768_a("energy", 2000);
            sawmillUndeadWood.func_74782_a("input", (NBTBase)new ItemStack(UndeadLogConfig._instance.getBlockInstance()).func_77955_b(new NBTTagCompound()));
            sawmillUndeadWood.func_74782_a("primaryOutput", (NBTBase)new ItemStack(UndeadPlankConfig._instance.getBlockInstance(), 6).func_77955_b(new NBTTagCompound()));
            FMLInterModComms.sendMessage((String)TE, (String)"addsawmillrecipe", (NBTTagCompound)sawmillUndeadWood);
        }
        if (Configs.isEnabled(DarkOreConfig.class) && Configs.isEnabled(DarkGemConfig.class)) {
            boolean crushedEnabled = Configs.isEnabled(DarkGemCrushedConfig.class);
            NBTTagCompound pulverizerDarkOre = new NBTTagCompound();
            pulverizerDarkOre.func_74768_a("energy", 2000);
            pulverizerDarkOre.func_74782_a("input", (NBTBase)new ItemStack((Block)DarkOre.getInstance()).func_77955_b(new NBTTagCompound()));
            pulverizerDarkOre.func_74782_a("primaryOutput", (NBTBase)new ItemStack((Item)DarkGem.getInstance(), 2).func_77955_b(new NBTTagCompound()));
            if (crushedEnabled) {
                pulverizerDarkOre.func_74782_a("secondaryOutput", (NBTBase)new ItemStack(DarkGemCrushedConfig._instance.getItemInstance(), 1).func_77955_b(new NBTTagCompound()));
                pulverizerDarkOre.func_74768_a("secondaryChance", 30);
            }
            FMLInterModComms.sendMessage((String)TE, (String)"addpulverizerrecipe", (NBTTagCompound)pulverizerDarkOre);
        }
        if (Configs.isEnabled(DarkGemConfig.class) && Configs.isEnabled(DarkGemCrushedConfig.class)) {
            NBTTagCompound pulverizerDarkOre = new NBTTagCompound();
            pulverizerDarkOre.func_74768_a("energy", 4000);
            pulverizerDarkOre.func_74782_a("input", (NBTBase)new ItemStack((Item)DarkGem.getInstance()).func_77955_b(pulverizerDarkOre.func_74775_l("input")));
            pulverizerDarkOre.func_74782_a("primaryOutput", (NBTBase)new ItemStack(DarkGemCrushedConfig._instance.getItemInstance(), 1).func_77955_b(pulverizerDarkOre.func_74775_l("primaryOutput")));
            FMLInterModComms.sendMessage((String)TE, (String)"addpulverizerrecipe", (NBTTagCompound)pulverizerDarkOre);
        }
        List materialPoisonousList = OreDictionary.getOres((String)"materialPoisonous");
        for (ItemStack materialPoisonous : materialPoisonousList) {
            if (materialPoisonous.func_77952_i() == Short.MAX_VALUE) {
                materialPoisonous = materialPoisonous.func_77946_l();
                materialPoisonous.func_77964_b(0);
            }
            NBTTagCompound cruciblePoison = new NBTTagCompound();
            cruciblePoison.func_74768_a("energy", 2000);
            cruciblePoison.func_74782_a("input", (NBTBase)materialPoisonous.func_77955_b(new NBTTagCompound()));
            cruciblePoison.func_74782_a("output", (NBTBase)new FluidStack((Fluid)Poison.getInstance(), 250).writeToNBT(new NBTTagCompound()));
            FMLInterModComms.sendMessage((String)TE, (String)"addcruciblerecipe", (NBTTagCompound)cruciblePoison);
        }
        if (Configs.isEnabled(EnderTearConfig.class) && (ender = FluidRegistry.getFluid((String)"ender")) != null) {
            NBTTagCompound crucibleEnder = new NBTTagCompound();
            crucibleEnder.func_74768_a("energy", 40000);
            crucibleEnder.func_74782_a("input", (NBTBase)new ItemStack(EnderTearConfig._instance.getItemInstance()).func_77955_b(new NBTTagCompound()));
            crucibleEnder.func_74782_a("output", (NBTBase)new FluidStack(ender, EnderTearConfig.mbLiquidEnder).writeToNBT(new NBTTagCompound()));
            FMLInterModComms.sendMessage((String)TE, (String)"addcruciblerecipe", (NBTTagCompound)crucibleEnder);
        }
        if (Configs.isEnabled(HardenedBloodShardConfig.class)) {
            NBTTagCompound crucibleBloodShard = new NBTTagCompound();
            crucibleBloodShard.func_74768_a("energy", 200);
            crucibleBloodShard.func_74782_a("input", (NBTBase)new ItemStack(HardenedBloodShardConfig._instance.getItemInstance()).func_77955_b(new NBTTagCompound()));
            crucibleBloodShard.func_74782_a("output", (NBTBase)new FluidStack((Fluid)Blood.getInstance(), 100).writeToNBT(new NBTTagCompound()));
            FMLInterModComms.sendMessage((String)TE, (String)"addcruciblerecipe", (NBTTagCompound)crucibleBloodShard);
        }
        if (Configs.isEnabled(BloodInfuserConfig.class)) {
            for (IRecipe recipe : BloodInfuser.getInstance().getRecipeRegistry().allRecipes()) {
                if (((ItemFluidStackAndTierRecipeComponent)recipe.getInput()).getTier() != 0) continue;
                NBTTagCompound bloodInfuse = new NBTTagCompound();
                bloodInfuse.func_74768_a("energy", ((DurationXpRecipeProperties)recipe.getProperties()).getDuration() * 10);
                bloodInfuse.func_74782_a("input", (NBTBase)((ItemFluidStackAndTierRecipeComponent)recipe.getInput()).getItemStack().func_77955_b(new NBTTagCompound()));
                bloodInfuse.func_74782_a("output", (NBTBase)((ItemStackRecipeComponent)recipe.getOutput()).getItemStack().func_77955_b(new NBTTagCompound()));
                bloodInfuse.func_74757_a("reversible", false);
                FluidStack fluid = ((ItemFluidStackAndTierRecipeComponent)recipe.getInput()).getFluidStack().copy();
                fluid.amount = (int)((double)fluid.amount * 1.5);
                bloodInfuse.func_74782_a("fluid", (NBTBase)fluid.writeToNBT(new NBTTagCompound()));
                FMLInterModComms.sendMessage((String)TE, (String)"addtransposerfillrecipe", (NBTTagCompound)bloodInfuse);
            }
        }
        if (Configs.isEnabled(BloodWaxedCoalConfig.class)) {
            NBTTagCompound pulverizerDustCoal = new NBTTagCompound();
            pulverizerDustCoal.func_74768_a("energy", 2400);
            pulverizerDustCoal.func_74782_a("input", (NBTBase)new ItemStack(BloodWaxedCoalConfig._instance.getItemInstance()).func_77955_b(new NBTTagCompound()));
            List dustCoalList = OreDictionary.getOres((String)"dustCoal");
            if (!dustCoalList.isEmpty()) {
                ItemStack dustCoal = ((ItemStack)dustCoalList.get(0)).func_77946_l();
                dustCoal.field_77994_a = 2;
                pulverizerDustCoal.func_74782_a("primaryOutput", (NBTBase)dustCoal.func_77955_b(new NBTTagCompound()));
                List sulfurList = OreDictionary.getOres((String)"dustSulfur");
                if (!sulfurList.isEmpty()) {
                    ItemStack dustSulfur = ((ItemStack)sulfurList.get(0)).func_77946_l();
                    dustSulfur.field_77994_a = 1;
                    pulverizerDustCoal.func_74782_a("secondaryOutput", (NBTBase)dustSulfur.func_77955_b(new NBTTagCompound()));
                    pulverizerDustCoal.func_74768_a("secondaryChance", 20);
                }
                FMLInterModComms.sendMessage((String)TE, (String)"addpulverizerrecipe", (NBTTagCompound)pulverizerDustCoal);
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public String getComment() {
        return "Sawmill, Pulverizer, Magma Crucible and Fluid Transposer recipes.";
    }
}

