/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft;

import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.extendedconfig.DummyConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.tracking.Analytics;
import org.cyclops.cyclopscore.tracking.IModVersion;
import org.cyclops.cyclopscore.tracking.Versions;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;

public class GeneralConfig
extends DummyConfig {
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Config version for EvilCraft.\nDO NOT EDIT MANUALLY!", showInGui=false)
    public static String version = "0.10.30";
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Set 'true' to enable development debug mode. This will result in a lower performance!", requiresMcRestart=true)
    public static boolean debug = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the recipe loader should crash when finding invalid recipes.", requiresMcRestart=true)
    public static boolean crashOnInvalidRecipe = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If mod compatibility loader should crash hard if errors occur in that process.", requiresMcRestart=true)
    public static boolean crashOnModCompatCrash = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If an anonymous mod startup analytics request may be sent to our analytics service.")
    public static boolean analytics = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="Evil stuff...", isCommandable=true)
    public static boolean dieWithoutAnyReason = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the version checker should be enabled.")
    public static boolean versionChecker = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="Server-side: If farting is enabled on this server; Client-side: If farting can be seen at your client.", isCommandable=true)
    public static boolean farting = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.FLUID, comment="The allowed blood conversions with their ratio. (ratio 2 means that this fluid is 1mB of this fluid can be converted into 2mB of EvilCraft Blood.", changedCallback=BloodFluidConverter.BloodConvertersChanged.class)
    public static String[] bloodConverters = new String[]{"blood:1.0", "lifeessence:1.0", "hell_blood:1.0"};
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="If retro-generation of ores should be enabled. WARNING: This could cause lag if permanently enabled.", isCommandable=true)
    public static boolean retrogen = false;
    public static ConfigurableType TYPE = ConfigurableType.DUMMY;
    @ConfigurableProperty(category=ConfigurableTypeCategory.WORLDGENERATION, comment="Spawn extra netherfish blocks in all biomes.")
    public static boolean extraSilverfish = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.WORLDGENERATION, comment="Minimum block height at which a dark temple can spawn.")
    public static int darkTempleMinHeight = 60;
    @ConfigurableProperty(category=ConfigurableTypeCategory.WORLDGENERATION, comment="Maximum blockState height at which a dark temple can spawn.")
    public static int darkTempleMaxHeight = 256;
    @ConfigurableProperty(category=ConfigurableTypeCategory.WORLDGENERATION, comment="Frequency at which dark temples should occur. 1 means every chunk, 100 means every 100th chunk.")
    public static int darkTempleFrequency = 250;
    @ConfigurableProperty(category=ConfigurableTypeCategory.WORLDGENERATION, comment="Maximal length of the pillars of a dark temple.")
    public static int darkTempleMaxPillarLength = 20;
    @ConfigurableProperty(category=ConfigurableTypeCategory.WORLDGENERATION, comment="Whitelisted dimensions in which dark temples can generate.")
    public static int[] darkTempleDimensions = new int[]{0};
    @ConfigurableProperty(category=ConfigurableTypeCategory.WORLDGENERATION, comment="The minimum distance in chunks between dark temples, higher values will slow down worldgen.")
    public static int darkTempleMinimumChunkDistance = 40;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="The amount of mB that can flow per tick out of machines and items.", requiresMcRestart=true)
    public static int mbFlowRate = 100;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="The minimum array size of potion types, increase to allow for more potion types.", minimalValue=256, maximalValue=2560, requiresMcRestart=true)
    public static int minimumPotionTypesArraySize = 256;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="[Thaumcraft] If temporary warp should be added when hit by a Vengeance Spirit.", requiresMcRestart=true)
    public static boolean thaumcraftVengeanceSpiritWarp = true;
    public static int silverfish_BlocksPerVein = 4;
    public static int silverfish_VeinsPerChunk = 10;
    public static int silverfish_StartY = 6;
    public static int silverfish_EndY = 66;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="If the blood gui overlay should be rendered.", isCommandable=true)
    public static boolean bloodGuiOverlay = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="The position to render the blood gui overlay at. (0=NE, 1=SE, 2=SW,3=NW)", isCommandable=true)
    public static int bloodGuiOverlayPosition = 1;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="The X offset for the blood gui overlay.", isCommandable=true)
    public static int bloodGuiOverlayPositionOffsetX = -5;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="The Y offset for the blood gui overlay.", isCommandable=true)
    public static int bloodGuiOverlayPositionOffsetY = -5;
    @ConfigurableProperty(category=ConfigurableTypeCategory.WORLDGENERATION, comment="The spawn chance for loot chests in dark temples, set to zero to completely disable.", isCommandable=true, requiresMcRestart=true)
    public static double darkTempleChestChance = 0.15;

    public GeneralConfig() {
        super((ModBase)EvilCraft._instance, true, "general", null, GeneralConfig.class);
    }

    public void onRegistered() {
        if (!version.equals("0.10.30")) {
            System.err.println("The config file of EvilCraft is out of date and might cause problems, please remove it so it can be regenerated.");
        }
        this.getMod().putGenericReference(ModBase.REFKEY_RETROGEN, (Object)retrogen);
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_INVALID_RECIPE, (Object)crashOnInvalidRecipe);
        this.getMod().putGenericReference(ModBase.REFKEY_DEBUGCONFIG, (Object)debug);
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_MODCOMPAT_CRASH, (Object)crashOnModCompatCrash);
        if (analytics) {
            Analytics.registerMod((ModBase)this.getMod(), (String)"UA-65307010-2");
        }
        if (versionChecker) {
            Versions.registerMod((ModBase)this.getMod(), (IModVersion)EvilCraft._instance, (String)"https://raw.githubusercontent.com/CyclopsMC/Versions/master/1.11/EvilCraft.txt");
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

