/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.recipe.custom.api.IMachine;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeRegistry;
import org.cyclops.cyclopscore.recipe.custom.api.ISuperRecipeRegistry;
import org.cyclops.cyclopscore.recipe.custom.component.ItemStackRecipeComponent;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.client.gui.container.GuiBloodInfuser;
import org.cyclops.evilcraft.client.particle.ParticleBloodBubble;
import org.cyclops.evilcraft.core.config.configurable.ConfigurableBlockContainerGuiTankInfo;
import org.cyclops.evilcraft.core.recipe.custom.DurationXpRecipeProperties;
import org.cyclops.evilcraft.core.recipe.custom.ItemFluidStackAndTierRecipeComponent;
import org.cyclops.evilcraft.core.tileentity.WorkingTileEntity;
import org.cyclops.evilcraft.inventory.container.ContainerBloodInfuser;
import org.cyclops.evilcraft.tileentity.TileBloodInfuser;

public class BloodInfuser
extends ConfigurableBlockContainerGuiTankInfo
implements IMachine<BloodInfuser, ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> {
    @BlockProperty
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    @BlockProperty
    public static final PropertyBool ON = PropertyBool.func_177716_a((String)"on");
    private static BloodInfuser _instance = null;

    public static BloodInfuser getInstance() {
        return _instance;
    }

    public BloodInfuser(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151576_e, TileBloodInfuser.class);
        this.func_149672_a(SoundType.field_185851_d);
        this.setRotatable(true);
    }

    public Item func_180660_a(IBlockState state, Random random, int zero) {
        return Item.func_150898_a((Block)this);
    }

    @Override
    public int getDefaultCapacity() {
        return 10000;
    }

    public IRecipeRegistry<BloodInfuser, ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> getRecipeRegistry() {
        return ((ISuperRecipeRegistry)EvilCraft._instance.getRegistryManager().getRegistry(ISuperRecipeRegistry.class)).getRecipeRegistry((IMachine)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos blockPos, Random random) {
        ParticleBloodBubble.randomDisplayTick((WorkingTileEntity)world.func_175625_s(blockPos), world, blockPos, random, (EnumFacing)BlockHelpers.getSafeBlockStateProperty((IBlockState)state, (IProperty)FACING, (Object)EnumFacing.NORTH));
        super.func_180655_c(state, world, blockPos, random);
    }

    public int getLightValue(IBlockState blockState, IBlockAccess world, BlockPos blockPos) {
        TileBloodInfuser tile = (TileBloodInfuser)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)blockPos, TileBloodInfuser.class);
        return tile != null && tile.isVisuallyWorking() ? 4 : super.getLightValue(blockState, world, blockPos);
    }

    public Class<? extends Container> getContainer() {
        return ContainerBloodInfuser.class;
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GuiScreen> getGui() {
        return GuiBloodInfuser.class;
    }
}

