/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.block.property.UnlistedProperty;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.cyclopscore.tileentity.TankInventoryTileEntity;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.block.DarkTankConfig;
import org.cyclops.evilcraft.client.render.model.ModelDarkTank;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.core.helper.BlockTankHelpers;
import org.cyclops.evilcraft.fluid.Blood;
import org.cyclops.evilcraft.fluid.BloodConfig;
import org.cyclops.evilcraft.tileentity.TileDarkTank;

public class DarkTank
extends ConfigurableBlockContainer
implements IInformationProvider,
IBlockTank {
    @BlockProperty
    public static final PropertyBool DRAINING = PropertyBool.func_177716_a((String)"draining");
    @BlockProperty
    public static final IUnlistedProperty<FluidStack> TANK_FLUID = new UnlistedProperty("tank_fluidstack", FluidStack.class);
    @BlockProperty
    public static final IUnlistedProperty<Integer> TANK_CAPACITY = new UnlistedProperty("tank_capacity", Integer.class);
    private static DarkTank _instance = null;
    @SideOnly(value=Side.CLIENT)
    private ModelResourceLocation[] itemModels;

    public static DarkTank getInstance() {
        return _instance;
    }

    public DarkTank(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151592_s, TileDarkTank.class);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185853_f);
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (MinecraftHelpers.isClientSide()) {
            this.itemModels = new ModelResourceLocation[2];
            this.itemModels[0] = new ModelResourceLocation(eConfig.getMod().getModId() + ":" + eConfig.getNamedId() + "_off", "inventory");
            this.itemModels[1] = new ModelResourceLocation(eConfig.getMod().getModId() + ":" + eConfig.getNamedId() + "_on", "inventory");
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.125, (double)0.001f, 0.125, 0.875, (double)0.999f, 0.875);
    }

    public boolean func_149740_M(IBlockState blockState) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos blockPos) {
        TankInventoryTileEntity tile = (TankInventoryTileEntity)world.func_175625_s(blockPos);
        float output = (float)tile.getTank().getFluidAmount() / (float)tile.getTank().getCapacity();
        return (int)Math.ceil(15.0f * output);
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_149721_r(IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos blockPos, EnumFacing side) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer player, EnumHand hand, EnumFacing side, float motionX, float motionY, float motionZ) {
        if (BlockTankHelpers.onBlockActivatedTank(world, blockPos, player, hand, side, motionX, motionY, motionZ)) {
            return true;
        }
        world.func_180501_a(blockPos, this.field_176227_L.func_177621_b().func_177226_a((IProperty)DRAINING, (Comparable)Boolean.valueOf((Boolean)blockState.func_177229_b((IProperty)DRAINING) == false)), 2);
        return true;
    }

    public String getInfo(ItemStack itemStack) {
        return BlockTankHelpers.getInfoTank(itemStack);
    }

    public void provideInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
    }

    protected ItemStack tileDataToItemStack(CyclopsTileEntity tile, ItemStack itemStack) {
        return BlockTankHelpers.tileDataToItemStack((TileEntity)tile, itemStack);
    }

    public int getLightValue(IBlockState blockState, IBlockAccess world, BlockPos blockPos) {
        TileDarkTank tile = (TileDarkTank)((Object)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)blockPos, TileDarkTank.class));
        if (tile != null && tile.getTank().getFluidType() != null) {
            return (int)Math.min(15.0, tile.getFillRatio() * (double)tile.getTank().getFluidType().getLuminosity() * 15.0);
        }
        return 0;
    }

    @Override
    public int getDefaultCapacity() {
        return 16000;
    }

    @Override
    public boolean isActivatable() {
        return true;
    }

    @Override
    public ItemStack toggleActivation(ItemStack itemStack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                ItemStack activated = itemStack.func_77946_l();
                activated.func_77964_b(1 - activated.func_77952_i());
                return activated;
            }
            return itemStack;
        }
        return itemStack;
    }

    @Override
    public boolean isActivated(ItemStack itemStack, World world, Entity entity) {
        return itemStack.func_77952_i() == 1;
    }

    public int func_180651_a(IBlockState blockState) {
        return (Boolean)blockState.func_177229_b((IProperty)DRAINING) != false ? 1 : 0;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        int lastCapacity;
        int capacityOriginal;
        ItemStack itemStack = new ItemStack(item);
        int capacity = capacityOriginal = 16000;
        do {
            IFluidHandlerItemCapacity fluidHandler = FluidHelpers.getFluidHandlerItemCapacity((ItemStack)itemStack.func_77946_l());
            fluidHandler.setCapacity(capacity);
            list.add((Object)fluidHandler.getContainer().func_77946_l());
            if (Configs.isEnabled(BloodConfig.class)) {
                int a = fluidHandler.fill(new FluidStack((Fluid)Blood.getInstance(), capacity), true);
                list.add((Object)fluidHandler.getContainer().func_77946_l());
            }
            lastCapacity = capacity;
        } while ((capacity <<= 2) < Math.min(DarkTankConfig.maxTankCreativeSize, DarkTankConfig.maxTankSize) && capacity > lastCapacity);
        if (DarkTankConfig.creativeTabFluids) {
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                if (fluid == null || fluid == Blood.getInstance()) continue;
                try {
                    ItemStack itemStackFilled = itemStack.func_77946_l();
                    IFluidHandlerItemCapacity fluidHandlerFilled = FluidHelpers.getFluidHandlerItemCapacity((ItemStack)itemStackFilled);
                    fluidHandlerFilled.setCapacity(capacityOriginal);
                    fluidHandlerFilled.fill(new FluidStack(fluid, capacityOriginal), true);
                    list.add((Object)fluidHandlerFilled.getContainer());
                }
                catch (NullPointerException e) {}
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        for (ModelResourceLocation itemModel : this.itemModels) {
            IBakedModel baseModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)itemModel);
            ModelDarkTank newModel = new ModelDarkTank(baseModel);
            event.getModelRegistry().func_82595_a((Object)itemModel, (Object)newModel);
        }
        if (DarkTankConfig.staticBlockRendering) {
            ModelResourceLocation blockDrainingOf = new ModelResourceLocation("evilcraft:darkTank", "draining=false");
            ModelResourceLocation blockDrainingOn = new ModelResourceLocation("evilcraft:darkTank", "draining=true");
            event.getModelRegistry().func_82595_a((Object)blockDrainingOf, (Object)new ModelDarkTank((IBakedModel)event.getModelRegistry().func_82594_a((Object)blockDrainingOf)));
            event.getModelRegistry().func_82595_a((Object)blockDrainingOn, (Object)new ModelDarkTank((IBakedModel)event.getModelRegistry().func_82594_a((Object)blockDrainingOn)));
        }
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        TileDarkTank tile = (TileDarkTank)((Object)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileDarkTank.class));
        if (tile != null) {
            FluidStack fluidStack = tile.getTank().getFluid();
            if (fluidStack != null) {
                extendedBlockState = extendedBlockState.withProperty(TANK_FLUID, (Object)fluidStack);
            }
            extendedBlockState = extendedBlockState.withProperty(TANK_CAPACITY, (Object)tile.getTank().getCapacity());
        }
        return extendedBlockState;
    }
}

