/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.evilcraft.ExtendedDamageSource;
import org.cyclops.evilcraft.block.SanguinaryPedestal;
import org.cyclops.evilcraft.block.SpikedPlateConfig;
import org.cyclops.evilcraft.core.config.configurable.ConfigurableBlockBasePressurePlate;
import org.cyclops.evilcraft.core.helper.obfuscation.ObfuscationHelpers;
import org.cyclops.evilcraft.tileentity.TileSanguinaryPedestal;

public class SpikedPlate
extends ConfigurableBlockBasePressurePlate {
    private static SpikedPlate _instance = null;

    public static SpikedPlate getInstance() {
        return _instance;
    }

    public SpikedPlate(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151576_e);
    }

    public boolean func_176196_c(World world, BlockPos blockPos) {
        return super.func_176196_c(world, blockPos) || world.func_180495_p(blockPos.func_177982_a(0, -1, 0)).func_177230_c() == SanguinaryPedestal.getInstance();
    }

    protected void func_185507_b(World worldIn, BlockPos color) {
    }

    protected void func_185508_c(World worldIn, BlockPos pos) {
    }

    protected boolean damageEntity(WorldServer world, Entity entity, BlockPos blockPos) {
        if (!(entity instanceof EntityPlayer) && entity instanceof EntityLivingBase) {
            float damage = (float)SpikedPlateConfig.damage;
            ObfuscationHelpers.setRecentlyHit((EntityLivingBase)entity, 100);
            if (entity.func_70097_a((DamageSource)ExtendedDamageSource.spikedDamage(world), damage)) {
                TileEntity tile = world.func_175625_s(blockPos.func_177982_a(0, -1, 0));
                if (tile != null && tile instanceof TileSanguinaryPedestal) {
                    int amount = MathHelper.func_76141_d((float)(damage * (float)SpikedPlateConfig.mobMultiplier));
                    ((TileSanguinaryPedestal)tile).fillWithPotentialBonus(new FluidStack(TileSanguinaryPedestal.FLUID, amount));
                }
                return true;
            }
        }
        return false;
    }

    protected int func_180669_e(World world, BlockPos blockPos) {
        AxisAlignedBB axisalignedbb = this.func_185496_a(world.func_180495_p(blockPos), (IBlockAccess)world, blockPos);
        List list = world.func_72872_a(EntityLivingBase.class, axisalignedbb.func_186670_a(blockPos));
        int ret = 0;
        if (!world.field_72995_K && list != null && !list.isEmpty()) {
            for (EntityLivingBase entity : list) {
                if (entity.func_145773_az() || !this.damageEntity((WorldServer)world, (Entity)entity, blockPos)) continue;
                ret = 15;
            }
        }
        return ret;
    }

    protected int func_176576_e(IBlockState blockState) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    protected IBlockState func_176575_a(IBlockState blockState, int meta) {
        return blockState.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta > 0));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos blockPos) {
        IBlockState blockState = world.func_180495_p(blockPos);
        boolean flag = this.func_176576_e(blockState) > 0;
        float offset = 0.0f;
        float f = 0.0775f;
        TileEntity tile = world.func_175625_s(blockPos.func_177982_a(0, -1, 0));
        if (tile != null && tile instanceof TileSanguinaryPedestal) {
            offset = -0.025f;
        }
        if (flag) {
            return new AxisAlignedBB((double)f, (double)offset, (double)f, (double)(1.0f - f), (double)(0.03125f + offset), (double)(1.0f - f));
        }
        return new AxisAlignedBB((double)f, (double)offset, (double)f, (double)(1.0f - f), (double)(0.0625f + offset), (double)(1.0f - f));
    }

    public boolean canCreatureSpawn(IBlockState blockState, IBlockAccess world, BlockPos blockPos, EntityLiving.SpawnPlacementType type) {
        return true;
    }
}

