/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.client.model.DynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.evilcraft.core.config.configurable.ConfigurableBlockWithInnerBlocks;

public class ModelInnerBlock
extends DynamicItemAndBlockModel {
    private final ConfigurableBlockWithInnerBlocks block;
    private final IBakedModel baseModel;
    private final IBlockState blockState;
    private final EnumFacing facing;
    private final long rand;

    public ModelInnerBlock(ConfigurableBlockWithInnerBlocks block) {
        super(true, false);
        this.block = block;
        this.baseModel = null;
        this.blockState = null;
        this.facing = null;
        this.rand = 0L;
    }

    public ModelInnerBlock(ConfigurableBlockWithInnerBlocks block, IBakedModel baseModel, boolean item, IBlockState blockState, EnumFacing facing, long rand) {
        super(false, item);
        this.block = block;
        this.baseModel = baseModel;
        this.blockState = blockState;
        this.facing = facing;
        this.rand = rand;
    }

    public List<BakedQuad> getGeneralQuads() {
        if (this.baseModel == null) {
            return Collections.emptyList();
        }
        return this.baseModel.func_188616_a(this.blockState, this.facing, this.rand);
    }

    public IBakedModel handleBlockState(IBlockState blockState, EnumFacing side, long rand) {
        IBlockState innerBlockState = this.block.getBlockFromState(blockState);
        IBakedModel baseModel = RenderHelpers.getBakedModel((IBlockState)innerBlockState);
        return new ModelInnerBlock(this.block, baseModel, false, innerBlockState, side, rand);
    }

    public IBakedModel handleItemState(ItemStack stack, World world, EntityLivingBase entity) {
        IBlockState innerBlockState = this.block.getBlockFromMeta(stack != null ? stack.func_77952_i() : 0);
        return RenderHelpers.getBakedModel((IBlockState)innerBlockState);
    }

    public TextureAtlasSprite func_177554_e() {
        return RenderHelpers.getBakedModel((IBlockState)this.block.getBlockFromMeta(0)).func_177554_e();
    }
}

