/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.tileentity;

import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.evilcraft.block.BoxOfEternalClosure;
import org.cyclops.evilcraft.client.render.model.ModelBoxOfEternalClosureBaked;
import org.cyclops.evilcraft.entity.monster.VengeanceSpirit;
import org.cyclops.evilcraft.tileentity.TileBoxOfEternalClosure;
import org.lwjgl.opengl.GL11;

public class RenderTileEntityBoxOfEternalClosure
extends TileEntitySpecialRenderer<TileBoxOfEternalClosure> {
    private static final ResourceLocation END_SKY_TEXTURE = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation END_PORTAL_TEXTURE = new ResourceLocation("textures/entity/end_portal.png");
    private static final Random field_147527_e = new Random(31100L);
    private static final ResourceLocation beamTexture = new ResourceLocation("evilcraft", "textures/entities/beam.png");
    private static final FloatBuffer MODELVIEW = GLAllocation.func_74529_h((int)16);
    private static final FloatBuffer PROJECTION = GLAllocation.func_74529_h((int)16);
    FloatBuffer field_147528_b = GLAllocation.func_74529_h((int)16);

    public void renderTileEntityAt(TileBoxOfEternalClosure tile, double x, double y, double z, float partialTick, int destroyStage) {
        boolean hasFacing;
        IBlockState blockState = this.func_178459_a().func_180495_p(tile.func_174877_v());
        Block block = blockState.func_177230_c();
        if (!(block instanceof BoxOfEternalClosure)) {
            return;
        }
        GlStateManager.func_179111_a((int)2982, (FloatBuffer)MODELVIEW);
        GlStateManager.func_179111_a((int)2983, (FloatBuffer)PROJECTION);
        ResourceLocation texture = TextureMap.field_110575_b;
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else if (texture != null) {
            this.func_147499_a(texture);
        }
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179091_B();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.func_179101_C();
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        EnumFacing direction = (EnumFacing)BlockHelpers.getSafeBlockStateProperty((IBlockState)tile.func_145831_w().func_180495_p(tile.func_174877_v()), (IProperty)BoxOfEternalClosure.FACING, (Object)EnumFacing.NORTH);
        int rotation = 0;
        if (direction == EnumFacing.SOUTH) {
            rotation = 180;
        }
        if (direction == EnumFacing.NORTH) {
            rotation = 0;
        }
        if (direction == EnumFacing.WEST) {
            rotation = 90;
        }
        if (direction == EnumFacing.EAST) {
            rotation = -90;
        }
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178262_a(ModelBoxOfEternalClosureBaked.boxModel, 1.0f, 1.0f, 1.0f, 1.0f);
        float angle = tile.getPreviousLidAngle() + (tile.getLidAngle() - tile.getPreviousLidAngle()) * partialTick;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.375f, (float)0.25f);
        GlStateManager.func_179114_b((float)(-angle), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-0.375f, (float)-0.25f);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178262_a(ModelBoxOfEternalClosureBaked.boxLidModel, 1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.func_179121_F();
        if (angle > 0.0f && (hasFacing = blockState.func_177228_b().containsKey((Object)BoxOfEternalClosure.FACING))) {
            this.renderEnd(x, y, z, ((EnumFacing)blockState.func_177229_b((IProperty)BoxOfEternalClosure.FACING)).func_176740_k(), tile.func_174877_v().func_177986_g());
        }
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
        x += 0.5;
        y -= 0.5;
        z += 0.5;
        VengeanceSpirit target = tile.getTargetSpirit();
        if (target != null) {
            float innerRotation = (float)tile.innerRotation + partialTick;
            float yOffset = MathHelper.func_76126_a((float)(innerRotation * 0.2f)) / 4.0f + 0.5f;
            yOffset = (yOffset * yOffset + yOffset) * 0.2f;
            float rotateX = -(target.field_70130_N / 2.0f) - (float)((double)tile.func_174877_v().func_177958_n() - target.field_70165_t - (target.field_70169_q - target.field_70165_t) * (double)(1.0f - partialTick));
            float rotateY = target.field_70131_O / 2.0f - (float)((double)yOffset + (double)tile.func_174877_v().func_177956_o() - target.field_70163_u - (target.field_70167_r - target.field_70163_u) * (double)(1.0f - partialTick));
            float rotateZ = -(target.field_70130_N / 2.0f) - (float)((double)tile.func_174877_v().func_177952_p() - target.field_70161_v - (target.field_70166_s - target.field_70161_v) * (double)(1.0f - partialTick));
            float distance = MathHelper.func_76129_c((float)(rotateX * rotateX + rotateZ * rotateZ));
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z));
            GL11.glRotatef((float)((float)(-Math.atan2(rotateZ, rotateX)) * 180.0f / (float)Math.PI - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)((float)(-Math.atan2(distance, rotateY)) * 180.0f / (float)Math.PI - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer worldRenderer = tessellator.func_178180_c();
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2884);
            this.func_147499_a(beamTexture);
            GlStateManager.func_179103_j((int)7425);
            worldRenderer.func_181668_a(5, DefaultVertexFormats.field_181709_i);
            float zuv = MathHelper.func_76129_c((float)(rotateX * rotateX + rotateY * rotateY + rotateZ * rotateZ));
            float v1 = MathHelper.func_76129_c((float)(rotateX * rotateX + rotateY * rotateY + rotateZ * rotateZ)) / 32.0f - ((float)target.field_70173_aa + partialTick) * 0.01f;
            float v2 = 0.0f - ((float)target.field_70173_aa + partialTick) * 0.01f;
            int amount = 8;
            for (int i = 0; i <= amount; ++i) {
                float xuv = MathHelper.func_76126_a((float)((float)(i % amount) * (float)Math.PI * 2.0f / (float)amount)) * 0.75f;
                float yuv = MathHelper.func_76134_b((float)((float)(i % amount) * (float)Math.PI * 2.0f / (float)amount)) * 0.75f;
                float u = (float)(i % amount) * 1.0f / (float)amount;
                worldRenderer.func_181662_b((double)(xuv * 0.2f), (double)(yuv * 0.2f), 0.0).func_187315_a((double)u, (double)v2).func_181669_b(0, 0, 0, 255).func_181675_d();
                worldRenderer.func_181662_b((double)xuv, (double)yuv, (double)zuv).func_187315_a((double)u, (double)v1).func_181669_b(255, 255, 255, 255).func_181675_d();
            }
            tessellator.func_78381_a();
            GL11.glEnable((int)2884);
            GlStateManager.func_179103_j((int)7424);
            RenderHelper.func_74519_b();
            GL11.glPopMatrix();
        }
    }

    protected void renderEnd(double x, double y, double z, EnumFacing.Axis axis, long seedOffset) {
        float f = (float)this.field_147501_a.field_147560_j;
        float f1 = (float)this.field_147501_a.field_147561_k;
        float f2 = (float)this.field_147501_a.field_147558_l;
        GlStateManager.func_179140_f();
        field_147527_e.setSeed(31100L + seedOffset);
        float f3 = 0.25f;
        for (int i = 0; i < 16; ++i) {
            GlStateManager.func_179094_E();
            float f4 = 16 - i;
            float f5 = 0.0625f;
            float f6 = 1.0f / (f4 + 1.0f);
            if (i == 0) {
                this.func_147499_a(END_SKY_TEXTURE);
                f6 = 0.1f;
                f4 = 65.0f;
                f5 = 0.125f;
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
            }
            if (i >= 1) {
                this.func_147499_a(END_PORTAL_TEXTURE);
            }
            if (i == 1) {
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)1, (int)1);
                f5 = 0.5f;
            }
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9217);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9217);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9217);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.Q, (int)9216);
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9473, (FloatBuffer)this.func_147525_a(1.0f, 0.0f, 0.0f, 0.0f));
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9473, (FloatBuffer)this.func_147525_a(0.0f, 0.0f, 1.0f, 0.0f));
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9473, (FloatBuffer)this.func_147525_a(0.0f, 0.0f, 0.0f, 1.0f));
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.Q, (int)9474, (FloatBuffer)this.func_147525_a(0.0f, 1.0f, 0.0f, 0.0f));
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.S);
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.T);
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.R);
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.Q);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)((float)((Minecraft.func_71386_F() + seedOffset) % 700000L) / 700000.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)f5, (float)f5, (float)f5);
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(i * i * 4321 + i * 9) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179110_a((FloatBuffer)PROJECTION);
            GlStateManager.func_179110_a((FloatBuffer)MODELVIEW);
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer worldrenderer = tessellator.func_178180_c();
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            float f11 = (field_147527_e.nextFloat() * 0.5f + 0.5f) * f6;
            float f12 = (field_147527_e.nextFloat() * 0.5f + 0.2f) * f6;
            float f13 = (field_147527_e.nextFloat() * 0.5f + 0.2f) * f6;
            if (i == 0) {
                f12 = f13 = 1.0f * f6;
                f11 = f13;
            }
            double edgeX = axis == EnumFacing.Axis.Y ? 0.3125 : 0.0;
            double edgeZ = axis == EnumFacing.Axis.Y ? 0.0 : 0.3125;
            worldrenderer.func_181662_b(0.0 + edgeX, (double)f3, 0.0 + edgeZ).func_181666_a(f11, f12, f13, 1.0f).func_181675_d();
            worldrenderer.func_181662_b(0.0 + edgeX, (double)f3, 1.0 - edgeZ).func_181666_a(f11, f12, f13, 1.0f).func_181675_d();
            worldrenderer.func_181662_b(1.0 - edgeX, (double)f3, 1.0 - edgeZ).func_181666_a(f11, f12, f13, 1.0f).func_181675_d();
            worldrenderer.func_181662_b(1.0 - edgeX, (double)f3, 0.0 + edgeZ).func_181666_a(f11, f12, f13, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
            this.func_147499_a(END_SKY_TEXTURE);
        }
        GlStateManager.func_179112_b((int)1, (int)1);
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.S);
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.T);
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.R);
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.Q);
        GlStateManager.func_179145_e();
    }

    private FloatBuffer func_147525_a(float p_147525_1_, float p_147525_2_, float p_147525_3_, float p_147525_4_) {
        this.field_147528_b.clear();
        this.field_147528_b.put(p_147525_1_).put(p_147525_2_).put(p_147525_3_).put(p_147525_4_);
        this.field_147528_b.flip();
        return this.field_147528_b;
    }
}

