/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.broom;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.IBroomModifierRegistry;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomPartModifier;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.item.BroomConfig;

public class BroomModifierRegistry
implements IBroomModifierRegistry {
    private static final String NBT_TAG_NAME = "broom_modifiers_tag";
    private static final String NBT_TAG_KEY = "id";
    private static final String NBT_TAG_VALUE = "value";
    private final Map<ResourceLocation, BroomModifier> broomModifiers = Maps.newLinkedHashMap();
    private final Map<BroomModifier, IBroomPart> broomModifierParts = Maps.newHashMap();
    private final Map<ItemStack, Map<BroomModifier, Float>> broomItems = Maps.newHashMap();

    public BroomModifierRegistry() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public BroomModifier registerModifier(BroomModifier modifier) {
        this.broomModifiers.put(modifier.getId(), modifier);
        BroomPartModifier broomPart = new BroomPartModifier(modifier);
        this.overrideDefaultModifierPart(modifier, broomPart);
        return modifier;
    }

    @Override
    public void overrideDefaultModifierPart(BroomModifier modifier, @Nullable IBroomPart broomPart) {
        this.broomModifierParts.put(modifier, broomPart);
        if (broomPart != null) {
            BroomParts.REGISTRY.registerPart(broomPart);
        }
    }

    @Override
    @Nullable
    public IBroomPart getModifierPart(BroomModifier modifier) {
        return this.broomModifierParts.get(modifier);
    }

    @Override
    public void registerModifiersItem(Map<BroomModifier, Float> modifiers, ItemStack item) {
        Objects.requireNonNull(item.func_77973_b());
        this.broomItems.put(item, modifiers);
    }

    @Override
    public void registerModifiersItem(BroomModifier modifier, float modifierValue, ItemStack item) {
        HashMap map = Maps.newHashMap();
        map.put(modifier, Float.valueOf(modifierValue));
        this.registerModifiersItem(map, item);
    }

    @Override
    public Map<BroomModifier, Float> getModifiersFromItem(ItemStack item) {
        for (Map.Entry<ItemStack, Map<BroomModifier, Float>> entry : this.broomItems.entrySet()) {
            if (!ItemStack.func_179545_c((ItemStack)item, (ItemStack)entry.getKey()) || !ItemStack.func_77970_a((ItemStack)item, (ItemStack)entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public Map<ItemStack, Float> getItemsFromModifier(BroomModifier modifier) {
        HashMap modifiers = Maps.newHashMap();
        for (Map.Entry<ItemStack, Map<BroomModifier, Float>> entry : this.broomItems.entrySet()) {
            for (Map.Entry<BroomModifier, Float> itModifiers : entry.getValue().entrySet()) {
                if (itModifiers.getKey() != modifier) continue;
                modifiers.put(entry.getKey(), itModifiers.getValue());
            }
        }
        return modifiers;
    }

    @Override
    public Collection<BroomModifier> getModifiers() {
        return Collections.unmodifiableCollection(this.broomModifiers.values());
    }

    @Override
    public Map<BroomModifier, Float> getModifiers(ItemStack broomStack) {
        if (broomStack != null) {
            HashMap modifiers = Maps.newHashMap();
            for (BroomModifier modifier : this.getModifiers()) {
                if (!modifier.isBaseModifier()) continue;
                modifiers.put(modifier, Float.valueOf(modifier.getDefaultValue()));
            }
            if (broomStack.func_77942_o()) {
                NBTTagList tags = broomStack.func_77978_p().func_150295_c(NBT_TAG_NAME, MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal());
                for (int i = 0; i < tags.func_74745_c(); ++i) {
                    NBTTagCompound tag = tags.func_150305_b(i);
                    String id = tag.func_74779_i(NBT_TAG_KEY);
                    float value = tag.func_74760_g(NBT_TAG_VALUE);
                    BroomModifier modifier = this.broomModifiers.get(new ResourceLocation(id));
                    if (modifier == null) continue;
                    modifiers.put(modifier, Float.valueOf(value));
                }
            }
            return modifiers;
        }
        return Collections.emptyMap();
    }

    @Override
    public void setModifiers(ItemStack broomStack, Map<BroomModifier, Float> modifiers) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<BroomModifier, Float> entry : modifiers.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a(NBT_TAG_KEY, entry.getKey().getId().toString());
            tag.func_74776_a(NBT_TAG_VALUE, entry.getValue().floatValue());
            list.func_74742_a((NBTBase)tag);
        }
        if (!broomStack.func_77942_o()) {
            broomStack.func_77982_d(new NBTTagCompound());
        }
        broomStack.func_77978_p().func_74782_a(NBT_TAG_NAME, (NBTBase)list);
        Collection<IBroomPart> parts = BroomParts.REGISTRY.getBroomParts(broomStack);
        for (Map.Entry<BroomModifier, Float> entry : modifiers.entrySet()) {
            if (!(entry.getValue().floatValue() > 0.0f)) continue;
            IBroomPart part = this.getModifierPart(entry.getKey());
            int tier = BroomModifier.getTier(entry.getKey(), entry.getValue().floatValue());
            if (part == null) continue;
            for (int i = 0; i < tier; ++i) {
                parts.add(part);
            }
        }
        BroomParts.REGISTRY.setBroomParts(broomStack, parts);
    }

    @SubscribeEvent
    public void onTooltipEvent(ItemTooltipEvent event) {
        Map<BroomModifier, Float> modifiers;
        if (BroomConfig.broomModifierTooltips && (modifiers = this.getModifiersFromItem(event.getItemStack())) != null) {
            if (MinecraftHelpers.isShifted()) {
                event.getToolTip().add(TextFormatting.ITALIC + L10NHelpers.localize((String)"broom.modifiers.evilcraft.types.name", (Object[])new Object[0]));
                for (Map.Entry<BroomModifier, Float> entry : modifiers.entrySet()) {
                    event.getToolTip().add(entry.getKey().getTooltipLine("  ", entry.getValue().floatValue(), 0.0f, false));
                }
            } else {
                event.getToolTip().add(TextFormatting.ITALIC + L10NHelpers.localize((String)"broom.modifiers.evilcraft.shiftinfo", (Object[])new Object[0]));
            }
        }
    }
}

